# Copyright (c) 2020, NVIDIA CORPORATION. All rights reserved.
#
# NVIDIA CORPORATION and its licensors retain all intellectual property
# and proprietary rights in and to this software, related documentation
# and any modifications thereto.  Any use, reproduction, disclosure or
# distribution of this software and related documentation without an express
# license agreement from NVIDIA CORPORATION is strictly prohibited.

# abi-t19x/mach-t194/clk-t194.h
TEGRA194_CLK_ACTMON                = 1
TEGRA194_CLK_ADSP                  = 2
TEGRA194_CLK_ADSPNEON              = 3
TEGRA194_CLK_AHUB                  = 4
TEGRA194_CLK_APB2APE               = 5
TEGRA194_CLK_APE                   = 6
TEGRA194_CLK_AUD_MCLK              = 7
TEGRA194_CLK_AXI_CBB               = 8
TEGRA194_CLK_CAN1                  = 9
TEGRA194_CLK_CAN1_HOST             = 10
TEGRA194_CLK_CAN2                  = 11
TEGRA194_CLK_CAN2_HOST             = 12
TEGRA194_CLK_CEC                   = 13
TEGRA194_CLK_CLK_M                 = 14
TEGRA194_CLK_DMIC1                 = 15
TEGRA194_CLK_DMIC2                 = 16
TEGRA194_CLK_DMIC3                 = 17
TEGRA194_CLK_DMIC4                 = 18
TEGRA194_CLK_DPAUX                 = 19
TEGRA194_CLK_DPAUX1                = 20
TEGRA194_CLK_ACLK                  = 21
TEGRA194_CLK_MSS_ENCRYPT           = 22
TEGRA194_CLK_EQOS_RX_INPUT         = 23
TEGRA194_CLK_IQC2                  = 24
TEGRA194_CLK_AON_APB               = 25
TEGRA194_CLK_AON_NIC               = 26
TEGRA194_CLK_AON_CPU_NIC           = 27
TEGRA194_CLK_PLLA1                 = 28
TEGRA194_CLK_DSPK1                 = 29
TEGRA194_CLK_DSPK2                 = 30
TEGRA194_CLK_EMC                   = 31
TEGRA194_CLK_EQOS_AXI              = 32
TEGRA194_CLK_EQOS_PTP_REF          = 33
TEGRA194_CLK_EQOS_RX               = 34
TEGRA194_CLK_EQOS_TX               = 35
TEGRA194_CLK_EXTPERIPH1            = 36
TEGRA194_CLK_EXTPERIPH2            = 37
TEGRA194_CLK_EXTPERIPH3            = 38
TEGRA194_CLK_EXTPERIPH4            = 39
TEGRA194_CLK_FUSE                  = 40
TEGRA194_CLK_GPCCLK                = 41
TEGRA194_CLK_GPU_PWR               = 42
TEGRA194_CLK_HDA                   = 43
TEGRA194_CLK_HDA2CODEC_2X          = 44
TEGRA194_CLK_HDA2HDMICODEC         = 45
TEGRA194_CLK_HOST1X                = 46
TEGRA194_CLK_HSIC_TRK              = 47
TEGRA194_CLK_I2C1                  = 48
TEGRA194_CLK_I2C2                  = 49
TEGRA194_CLK_I2C3                  = 50
TEGRA194_CLK_I2C4                  = 51
TEGRA194_CLK_I2C6                  = 52
TEGRA194_CLK_I2C7                  = 53
TEGRA194_CLK_I2C8                  = 54
TEGRA194_CLK_I2C9                  = 55
TEGRA194_CLK_I2S1                  = 56
TEGRA194_CLK_I2S1_SYNC_INPUT       = 57
TEGRA194_CLK_I2S2                  = 58
TEGRA194_CLK_I2S2_SYNC_INPUT       = 59
TEGRA194_CLK_I2S3                  = 60
TEGRA194_CLK_I2S3_SYNC_INPUT       = 61
TEGRA194_CLK_I2S4                  = 62
TEGRA194_CLK_I2S4_SYNC_INPUT       = 63
TEGRA194_CLK_I2S5                  = 64
TEGRA194_CLK_I2S5_SYNC_INPUT       = 65
TEGRA194_CLK_I2S6                  = 66
TEGRA194_CLK_I2S6_SYNC_INPUT       = 67
TEGRA194_CLK_IQC1                  = 68
TEGRA194_CLK_ISP                   = 69
TEGRA194_CLK_KFUSE                 = 70
TEGRA194_CLK_MAUD                  = 71
TEGRA194_CLK_MIPI_CAL              = 72
TEGRA194_CLK_MPHY_CORE_PLL_FIXED   = 73
TEGRA194_CLK_MPHY_L0_RX_ANA        = 74
TEGRA194_CLK_MPHY_L0_RX_LS_BIT     = 75
TEGRA194_CLK_MPHY_L0_RX_SYMB       = 76
TEGRA194_CLK_MPHY_L0_TX_LS_3XBIT   = 77
TEGRA194_CLK_MPHY_L0_TX_SYMB       = 78
TEGRA194_CLK_MPHY_L1_RX_ANA        = 79
TEGRA194_CLK_MPHY_TX_1MHZ_REF      = 80
TEGRA194_CLK_NVCSI                 = 81
TEGRA194_CLK_NVCSILP               = 82
TEGRA194_CLK_NVDEC                 = 83
TEGRA194_CLK_NVDISPLAYHUB          = 84
TEGRA194_CLK_NVDISPLAY_DISP        = 85
TEGRA194_CLK_NVDISPLAY_P0          = 86
TEGRA194_CLK_NVDISPLAY_P1          = 87
TEGRA194_CLK_NVDISPLAY_P2          = 88
TEGRA194_CLK_NVENC                 = 89
TEGRA194_CLK_NVJPG                 = 90
TEGRA194_CLK_OSC                   = 91
TEGRA194_CLK_AON_TOUCH             = 92
TEGRA194_CLK_PLLA                  = 93
TEGRA194_CLK_PLLAON                = 94
TEGRA194_CLK_PLLD                  = 95
TEGRA194_CLK_PLLD2                 = 96
TEGRA194_CLK_PLLD3                 = 97
TEGRA194_CLK_PLLDP                 = 98
TEGRA194_CLK_PLLD4                 = 99
TEGRA194_CLK_PLLE                  = 100
TEGRA194_CLK_PLLP                  = 101
TEGRA194_CLK_PLLP_OUT0             = 102
TEGRA194_CLK_UTMIPLL               = 103
TEGRA194_CLK_PLLA_OUT0             = 104
TEGRA194_CLK_PWM1                  = 105
TEGRA194_CLK_PWM2                  = 106
TEGRA194_CLK_PWM3                  = 107
TEGRA194_CLK_PWM4                  = 108
TEGRA194_CLK_PWM5                  = 109
TEGRA194_CLK_PWM6                  = 110
TEGRA194_CLK_PWM7                  = 111
TEGRA194_CLK_PWM8                  = 112
TEGRA194_CLK_RCE_CPU_NIC           = 113
TEGRA194_CLK_RCE_NIC               = 114
TEGRA194_CLK_SATA                  = 115
TEGRA194_CLK_SATA_OOB              = 116
TEGRA194_CLK_AON_I2C_SLOW          = 117
TEGRA194_CLK_SCE_CPU_NIC           = 118
TEGRA194_CLK_SCE_NIC               = 119
TEGRA194_CLK_SDMMC1                = 120
TEGRA194_CLK_UPHY_PLL3             = 121
TEGRA194_CLK_SDMMC3                = 122
TEGRA194_CLK_SDMMC4                = 123
TEGRA194_CLK_SE                    = 124
TEGRA194_CLK_SOR0_OUT              = 125
TEGRA194_CLK_SOR0_REF              = 126
TEGRA194_CLK_SOR0_PAD_CLKOUT       = 127
TEGRA194_CLK_SOR1_OUT              = 128
TEGRA194_CLK_SOR1_REF              = 129
TEGRA194_CLK_SOR1_PAD_CLKOUT       = 130
TEGRA194_CLK_SOR_SAFE              = 131
TEGRA194_CLK_IQC1_IN               = 132
TEGRA194_CLK_IQC2_IN               = 133
TEGRA194_CLK_DMIC5                 = 134
TEGRA194_CLK_SPI1                  = 135
TEGRA194_CLK_SPI2                  = 136
TEGRA194_CLK_SPI3                  = 137
TEGRA194_CLK_I2C_SLOW              = 138
TEGRA194_CLK_SYNC_DMIC1            = 139
TEGRA194_CLK_SYNC_DMIC2            = 140
TEGRA194_CLK_SYNC_DMIC3            = 141
TEGRA194_CLK_SYNC_DMIC4            = 142
TEGRA194_CLK_SYNC_DSPK1            = 143
TEGRA194_CLK_SYNC_DSPK2            = 144
TEGRA194_CLK_SYNC_I2S1             = 145
TEGRA194_CLK_SYNC_I2S2             = 146
TEGRA194_CLK_SYNC_I2S3             = 147
TEGRA194_CLK_SYNC_I2S4             = 148
TEGRA194_CLK_SYNC_I2S5             = 149
TEGRA194_CLK_SYNC_I2S6             = 150
TEGRA194_CLK_MPHY_FORCE_LS_MODE    = 151
TEGRA194_CLK_TACH                  = 152
TEGRA194_CLK_TSEC                  = 153
TEGRA194_CLK_TSECB                 = 154
TEGRA194_CLK_UARTA                 = 155
TEGRA194_CLK_UARTB                 = 156
TEGRA194_CLK_UARTC                 = 157
TEGRA194_CLK_UARTD                 = 158
TEGRA194_CLK_UARTE                 = 159
TEGRA194_CLK_UARTF                 = 160
TEGRA194_CLK_UARTG                 = 161
TEGRA194_CLK_UART_FST_MIPI_CAL     = 162
TEGRA194_CLK_UFSDEV_REF            = 163
TEGRA194_CLK_UFSHC                 = 164
TEGRA194_CLK_USB2_TRK              = 165
TEGRA194_CLK_VI                    = 166
TEGRA194_CLK_VIC                   = 167
TEGRA194_CLK_PVA0_AXI              = 168
TEGRA194_CLK_PVA0_VPS0             = 169
TEGRA194_CLK_PVA0_VPS1             = 170
TEGRA194_CLK_PVA1_AXI              = 171
TEGRA194_CLK_PVA1_VPS0             = 172
TEGRA194_CLK_PVA1_VPS1             = 173
TEGRA194_CLK_DLA0_FALCON           = 174
TEGRA194_CLK_DLA0_CORE             = 175
TEGRA194_CLK_DLA1_FALCON           = 176
TEGRA194_CLK_DLA1_CORE             = 177
TEGRA194_CLK_SOR2_OUT              = 178
TEGRA194_CLK_SOR2_REF              = 179
TEGRA194_CLK_SOR2_PAD_CLKOUT       = 180
TEGRA194_CLK_SOR3_OUT              = 181
TEGRA194_CLK_SOR3_REF              = 182
TEGRA194_CLK_SOR3_PAD_CLKOUT       = 183
TEGRA194_CLK_NVDISPLAY_P3          = 184
TEGRA194_CLK_DPAUX2                = 185
TEGRA194_CLK_DPAUX3                = 186
TEGRA194_CLK_NVDEC1                = 187
TEGRA194_CLK_NVENC1                = 188
TEGRA194_CLK_SE_FREE               = 189
TEGRA194_CLK_UARTH                 = 190
TEGRA194_CLK_FUSE_SERIAL           = 191
TEGRA194_CLK_QSPI0                 = 192
TEGRA194_CLK_QSPI1                 = 193
TEGRA194_CLK_QSPI0_PM              = 194
TEGRA194_CLK_QSPI1_PM              = 195
TEGRA194_CLK_VI_CONST              = 196
TEGRA194_CLK_NAFLL_BPMP            = 197
TEGRA194_CLK_NAFLL_SCE             = 198
TEGRA194_CLK_NAFLL_NVDEC           = 199
TEGRA194_CLK_NAFLL_NVJPG           = 200
TEGRA194_CLK_NAFLL_TSEC            = 201
TEGRA194_CLK_NAFLL_TSECB           = 202
TEGRA194_CLK_NAFLL_VI              = 203
TEGRA194_CLK_NAFLL_SE              = 204
TEGRA194_CLK_NAFLL_NVENC           = 205
TEGRA194_CLK_NAFLL_ISP             = 206
TEGRA194_CLK_NAFLL_VIC             = 207
TEGRA194_CLK_NAFLL_NVDISPLAYHUB    = 208
TEGRA194_CLK_NAFLL_AXICBB          = 209
TEGRA194_CLK_NAFLL_DLA             = 210
TEGRA194_CLK_NAFLL_PVA_CORE        = 211
TEGRA194_CLK_NAFLL_PVA_VPS         = 212
TEGRA194_CLK_NAFLL_CVNAS           = 213
TEGRA194_CLK_NAFLL_RCE             = 214
TEGRA194_CLK_NAFLL_NVENC1          = 215
TEGRA194_CLK_NAFLL_DLA_FALCON      = 216
TEGRA194_CLK_NAFLL_NVDEC1          = 217
TEGRA194_CLK_NAFLL_GPU             = 218
TEGRA194_CLK_SDMMC_LEGACY_TM       = 219
TEGRA194_CLK_PEX0_CORE_0           = 220
TEGRA194_CLK_PEX0_CORE_1           = 221
TEGRA194_CLK_PEX0_CORE_2           = 222
TEGRA194_CLK_PEX0_CORE_3           = 223
TEGRA194_CLK_PEX0_CORE_4           = 224
TEGRA194_CLK_PEX1_CORE_5           = 225
TEGRA194_CLK_PEX_REF1              = 226
TEGRA194_CLK_PEX_REF2              = 227
TEGRA194_CLK_NVHS_REF              = 228
TEGRA194_CLK_CSI_A                 = 229
TEGRA194_CLK_CSI_B                 = 230
TEGRA194_CLK_CSI_C                 = 231
TEGRA194_CLK_CSI_D                 = 232
TEGRA194_CLK_CSI_E                 = 233
TEGRA194_CLK_CSI_F                 = 234
TEGRA194_CLK_CSI_G                 = 235
TEGRA194_CLK_CSI_H                 = 236
TEGRA194_CLK_PLLC4                 = 237
TEGRA194_CLK_PLLC4_OUT             = 238
TEGRA194_CLK_PLLC4_OUT1            = 239
TEGRA194_CLK_PLLC4_OUT2            = 240
TEGRA194_CLK_PLLC4_MUXED           = 241
TEGRA194_CLK_PLLC4_VCO_DIV2        = 242
TEGRA194_CLK_PLLNVHS               = 243
TEGRA194_CLK_CSI_A_PAD             = 244
TEGRA194_CLK_CSI_B_PAD             = 245
TEGRA194_CLK_CSI_C_PAD             = 246
TEGRA194_CLK_CSI_D_PAD             = 247
TEGRA194_CLK_CSI_E_PAD             = 248
TEGRA194_CLK_CSI_F_PAD             = 249
TEGRA194_CLK_CSI_G_PAD             = 250
TEGRA194_CLK_CSI_H_PAD             = 251
TEGRA194_CLK_SLVSEC                = 252
TEGRA194_CLK_SLVSEC_PADCTRL        = 253
TEGRA194_CLK_PEX_SATA_USB_RX_BYP   = 254
TEGRA194_CLK_PEX_USB_PAD_PLL0_MGMT = 255
TEGRA194_CLK_PEX_USB_PAD_PLL1_MGMT = 256
TEGRA194_CLK_PEX_USB_PAD_PLL2_MGMT = 257
TEGRA194_CLK_PEX_USB_PAD_PLL3_MGMT = 258
TEGRA194_CLK_NVLINK_SYS            = 259
TEGRA194_CLK_NVLINK_RX             = 260
TEGRA194_CLK_NVLINK_TX             = 261
TEGRA194_CLK_NVLINK_TX_DIV         = 262
TEGRA194_CLK_NVHS_RX_BYP_REF       = 263
TEGRA194_CLK_NVHS_PLL0_MGMT        = 264
TEGRA194_CLK_XUSB_CORE_DEV         = 265
TEGRA194_CLK_XUSB_CORE_MUX         = 266
TEGRA194_CLK_XUSB_CORE_HOST        = 267
TEGRA194_CLK_XUSB_CORE_SS          = 268
TEGRA194_CLK_XUSB_FALCON           = 269
TEGRA194_CLK_XUSB_FALCON_HOST      = 270
TEGRA194_CLK_XUSB_FALCON_SS        = 271
TEGRA194_CLK_XUSB_FS               = 272
TEGRA194_CLK_XUSB_FS_HOST          = 273
TEGRA194_CLK_XUSB_FS_DEV           = 274
TEGRA194_CLK_XUSB_SS               = 275
TEGRA194_CLK_XUSB_SS_DEV           = 276
TEGRA194_CLK_XUSB_SS_SUPERSPEED    = 277
TEGRA194_CLK_PLLDISPHUB            = 278
TEGRA194_CLK_PLLDISPHUB_DIV        = 279
TEGRA194_CLK_NAFLL_CLUSTER0        = 280
TEGRA194_CLK_NAFLL_CLUSTER1        = 281
TEGRA194_CLK_NAFLL_CLUSTER2        = 282
TEGRA194_CLK_NAFLL_CLUSTER3        = 283
TEGRA194_CLK_CAN1_CORE             = 284
TEGRA194_CLK_CAN2_CORE             = 285
TEGRA194_CLK_PLLA1_OUT1            = 286
TEGRA194_CLK_PLLNVHS_HPS           = 287
TEGRA194_CLK_PLLREFE_VCOOUT        = 288
TEGRA194_CLK_CLK_32K               = 289
TEGRA194_CLK_SPDIFIN_SYNC_INPUT    = 290
TEGRA194_CLK_UTMIPLL_CLKOUT48      = 291
TEGRA194_CLK_UTMIPLL_CLKOUT480     = 292
TEGRA194_CLK_CVNAS                 = 293
TEGRA194_CLK_PLLNVCSI              = 294
TEGRA194_CLK_PVA0_CPU_AXI          = 295
TEGRA194_CLK_PVA1_CPU_AXI          = 296
TEGRA194_CLK_PVA0_VPS              = 297
TEGRA194_CLK_PVA1_VPS              = 298
TEGRA194_CLK_DLA0_FALCON_MUX       = 299
TEGRA194_CLK_DLA1_FALCON_MUX       = 300
TEGRA194_CLK_DLA0_CORE_MUX         = 301
TEGRA194_CLK_DLA1_CORE_MUX         = 302
TEGRA194_CLK_UTMIPLL_HPS           = 304
TEGRA194_CLK_I2C5                  = 305
TEGRA194_CLK_I2C10                 = 306
TEGRA194_CLK_BPMP_CPU_NIC          = 307
TEGRA194_CLK_BPMP_APB              = 308
TEGRA194_CLK_TSC                   = 309
TEGRA194_CLK_EMCSA                 = 310
TEGRA194_CLK_EMCSB                 = 311
TEGRA194_CLK_EMCSC                 = 312
TEGRA194_CLK_EMCSD                 = 313
TEGRA194_CLK_PLLC                  = 314
TEGRA194_CLK_PLLC2                 = 315
TEGRA194_CLK_PLLC3                 = 316
TEGRA194_CLK_TSC_REF               = 317
TEGRA194_CLK_FUSE_BURN             = 318
TEGRA194_CLK_PEX0_CORE_0M          = 319
TEGRA194_CLK_PEX0_CORE_1M          = 320
TEGRA194_CLK_PEX0_CORE_2M          = 321
TEGRA194_CLK_PEX0_CORE_3M          = 322
TEGRA194_CLK_PEX0_CORE_4M          = 323
TEGRA194_CLK_PEX1_CORE_5M          = 324
TEGRA194_CLK_NVLINK_PLL_TXCLK      = 325
TEGRA194_CLK_PLLE_HPS              = 326
TEGRA194_CLK_PLLREFE_VCOOUT_GATED  = 327
TEGRA194_CLK_PLLP_DIV17            = 328
TEGRA194_CLK_SOC_THERM             = 329
TEGRA194_CLK_TSENSOR               = 330
TEGRA194_CLK_XUSB_PADCTL           = 331
TEGRA194_CLK_PLLBPMPCAM            = 332
TEGRA194_CLK_PLLP_OUT5             = 333
TEGRA194_CLK_OSC_DIV               = 334

# abi-t19x/mach-t194/mail-t194.h
TEGRA194_DB_BPMP   = 0x80000
TEGRA194_DB_CPU_NS = 0x20000
TEGRA194_DB_CPU_S  = 0x2
TEGRA194_DB_DMCE   = 0x4
TEGRA194_DB_RCE    = 0x40000000
TEGRA194_DB_SCE    = 0x200000
TEGRA194_DB_SPE    = 0x100000

doorbells = TEGRA194_DB_CPU_NS | \
            TEGRA194_DB_CPU_S | \
            TEGRA194_DB_DMCE | \
            TEGRA194_DB_RCE | \
            TEGRA194_DB_SCE | \
            TEGRA194_DB_SPE

enablers = doorbells | TEGRA194_DB_BPMP | 0x1

clocks = [
    TEGRA194_CLK_ACLK,
    TEGRA194_CLK_ACTMON,
    TEGRA194_CLK_ADSP,
    TEGRA194_CLK_ADSPNEON,
    TEGRA194_CLK_AHUB,
    TEGRA194_CLK_AON_APB,
    TEGRA194_CLK_AON_CPU_NIC,
    TEGRA194_CLK_AON_I2C_SLOW,
    TEGRA194_CLK_AON_NIC,
    TEGRA194_CLK_AON_TOUCH,
    TEGRA194_CLK_APB2APE,
    TEGRA194_CLK_APE,
    TEGRA194_CLK_AUD_MCLK,
    TEGRA194_CLK_AXI_CBB,
    TEGRA194_CLK_BPMP_APB,
    TEGRA194_CLK_BPMP_CPU_NIC,
    TEGRA194_CLK_CAN1,
    TEGRA194_CLK_CAN1_CORE,
    TEGRA194_CLK_CAN1_HOST,
    TEGRA194_CLK_CAN2,
    TEGRA194_CLK_CAN2_CORE,
    TEGRA194_CLK_CAN2_HOST,
    TEGRA194_CLK_CEC,
    TEGRA194_CLK_CLK_32K,
    TEGRA194_CLK_CLK_M,
    TEGRA194_CLK_CSI_A,
    TEGRA194_CLK_CSI_A_PAD,
    TEGRA194_CLK_CSI_B,
    TEGRA194_CLK_CSI_B_PAD,
    TEGRA194_CLK_CSI_C,
    TEGRA194_CLK_CSI_C_PAD,
    TEGRA194_CLK_CSI_D,
    TEGRA194_CLK_CSI_D_PAD,
    TEGRA194_CLK_CSI_E,
    TEGRA194_CLK_CSI_E_PAD,
    TEGRA194_CLK_CSI_F,
    TEGRA194_CLK_CSI_F_PAD,
    TEGRA194_CLK_CSI_G,
    TEGRA194_CLK_CSI_G_PAD,
    TEGRA194_CLK_CSI_H,
    TEGRA194_CLK_CSI_H_PAD,
    TEGRA194_CLK_CVNAS,
    TEGRA194_CLK_DLA0_CORE,
    TEGRA194_CLK_DLA0_CORE_MUX,
    TEGRA194_CLK_DLA0_FALCON,
    TEGRA194_CLK_DLA0_FALCON_MUX,
    TEGRA194_CLK_DLA1_CORE,
    TEGRA194_CLK_DLA1_CORE_MUX,
    TEGRA194_CLK_DLA1_FALCON,
    TEGRA194_CLK_DLA1_FALCON_MUX,
    TEGRA194_CLK_DMIC1,
    TEGRA194_CLK_DMIC2,
    TEGRA194_CLK_DMIC3,
    TEGRA194_CLK_DMIC4,
    TEGRA194_CLK_DMIC5,
    TEGRA194_CLK_DPAUX,
    TEGRA194_CLK_DPAUX1,
    TEGRA194_CLK_DPAUX2,
    TEGRA194_CLK_DPAUX3,
    TEGRA194_CLK_DSPK1,
    TEGRA194_CLK_DSPK2,
    TEGRA194_CLK_EMC,
    TEGRA194_CLK_EMCSA,
    TEGRA194_CLK_EMCSB,
    TEGRA194_CLK_EMCSC,
    TEGRA194_CLK_EMCSD,
    TEGRA194_CLK_EQOS_AXI,
    TEGRA194_CLK_EQOS_PTP_REF,
    TEGRA194_CLK_EQOS_RX,
    TEGRA194_CLK_EQOS_RX_INPUT,
    TEGRA194_CLK_EQOS_TX,
    TEGRA194_CLK_EXTPERIPH1,
    TEGRA194_CLK_EXTPERIPH2,
    TEGRA194_CLK_EXTPERIPH3,
    TEGRA194_CLK_EXTPERIPH4,
    TEGRA194_CLK_FUSE,
    TEGRA194_CLK_FUSE_BURN,
    TEGRA194_CLK_FUSE_SERIAL,
    TEGRA194_CLK_GPCCLK,
    TEGRA194_CLK_GPU_PWR,
    TEGRA194_CLK_HDA,
    TEGRA194_CLK_HDA2CODEC_2X,
    TEGRA194_CLK_HDA2HDMICODEC,
    TEGRA194_CLK_HOST1X,
    TEGRA194_CLK_HSIC_TRK,
    TEGRA194_CLK_I2C1,
    TEGRA194_CLK_I2C10,
    TEGRA194_CLK_I2C2,
    TEGRA194_CLK_I2C3,
    TEGRA194_CLK_I2C4,
    TEGRA194_CLK_I2C5,
    TEGRA194_CLK_I2C6,
    TEGRA194_CLK_I2C7,
    TEGRA194_CLK_I2C8,
    TEGRA194_CLK_I2C9,
    TEGRA194_CLK_I2C_SLOW,
    TEGRA194_CLK_I2S1,
    TEGRA194_CLK_I2S1_SYNC_INPUT,
    TEGRA194_CLK_I2S2,
    TEGRA194_CLK_I2S2_SYNC_INPUT,
    TEGRA194_CLK_I2S3,
    TEGRA194_CLK_I2S3_SYNC_INPUT,
    TEGRA194_CLK_I2S4,
    TEGRA194_CLK_I2S4_SYNC_INPUT,
    TEGRA194_CLK_I2S5,
    TEGRA194_CLK_I2S5_SYNC_INPUT,
    TEGRA194_CLK_I2S6,
    TEGRA194_CLK_I2S6_SYNC_INPUT,
    TEGRA194_CLK_IQC1,
    TEGRA194_CLK_IQC1_IN,
    TEGRA194_CLK_IQC2,
    TEGRA194_CLK_IQC2_IN,
    TEGRA194_CLK_ISP,
    TEGRA194_CLK_KFUSE,
    TEGRA194_CLK_MAUD,
    TEGRA194_CLK_MIPI_CAL,
    TEGRA194_CLK_MPHY_CORE_PLL_FIXED,
    TEGRA194_CLK_MPHY_FORCE_LS_MODE,
    TEGRA194_CLK_MPHY_L0_RX_ANA,
    TEGRA194_CLK_MPHY_L0_RX_LS_BIT,
    TEGRA194_CLK_MPHY_L0_RX_SYMB,
    TEGRA194_CLK_MPHY_L0_TX_LS_3XBIT,
    TEGRA194_CLK_MPHY_L0_TX_SYMB,
    TEGRA194_CLK_MPHY_L1_RX_ANA,
    TEGRA194_CLK_MPHY_TX_1MHZ_REF,
    TEGRA194_CLK_MSS_ENCRYPT,
    TEGRA194_CLK_NAFLL_AXICBB,
    TEGRA194_CLK_NAFLL_BPMP,
    TEGRA194_CLK_NAFLL_CLUSTER0,
    TEGRA194_CLK_NAFLL_CLUSTER1,
    TEGRA194_CLK_NAFLL_CLUSTER2,
    TEGRA194_CLK_NAFLL_CLUSTER3,
    TEGRA194_CLK_NAFLL_CVNAS,
    TEGRA194_CLK_NAFLL_DLA,
    TEGRA194_CLK_NAFLL_DLA_FALCON,
    TEGRA194_CLK_NAFLL_GPU,
    TEGRA194_CLK_NAFLL_ISP,
    TEGRA194_CLK_NAFLL_NVDEC,
    TEGRA194_CLK_NAFLL_NVDEC1,
    TEGRA194_CLK_NAFLL_NVDISPLAYHUB,
    TEGRA194_CLK_NAFLL_NVENC,
    TEGRA194_CLK_NAFLL_NVENC1,
    TEGRA194_CLK_NAFLL_NVJPG,
    TEGRA194_CLK_NAFLL_PVA_CORE,
    TEGRA194_CLK_NAFLL_PVA_VPS,
    TEGRA194_CLK_NAFLL_RCE,
    TEGRA194_CLK_NAFLL_SCE,
    TEGRA194_CLK_NAFLL_SE,
    TEGRA194_CLK_NAFLL_TSEC,
    TEGRA194_CLK_NAFLL_TSECB,
    TEGRA194_CLK_NAFLL_VI,
    TEGRA194_CLK_NAFLL_VIC,
    TEGRA194_CLK_NVCSI,
    TEGRA194_CLK_NVCSILP,
    TEGRA194_CLK_NVDEC,
    TEGRA194_CLK_NVDEC1,
    TEGRA194_CLK_NVDISPLAYHUB,
    TEGRA194_CLK_NVDISPLAY_DISP,
    TEGRA194_CLK_NVDISPLAY_P0,
    TEGRA194_CLK_NVDISPLAY_P1,
    TEGRA194_CLK_NVDISPLAY_P2,
    TEGRA194_CLK_NVDISPLAY_P3,
    TEGRA194_CLK_NVENC,
    TEGRA194_CLK_NVENC1,
    TEGRA194_CLK_NVHS_PLL0_MGMT,
    TEGRA194_CLK_NVHS_REF,
    TEGRA194_CLK_NVHS_RX_BYP_REF,
    TEGRA194_CLK_NVJPG,
    TEGRA194_CLK_NVLINK_PLL_TXCLK,
    TEGRA194_CLK_NVLINK_RX,
    TEGRA194_CLK_NVLINK_SYS,
    TEGRA194_CLK_NVLINK_TX,
    TEGRA194_CLK_NVLINK_TX_DIV,
    TEGRA194_CLK_OSC,
    TEGRA194_CLK_OSC_DIV,
    TEGRA194_CLK_PEX0_CORE_0,
    TEGRA194_CLK_PEX0_CORE_0M,
    TEGRA194_CLK_PEX0_CORE_1,
    TEGRA194_CLK_PEX0_CORE_1M,
    TEGRA194_CLK_PEX0_CORE_2,
    TEGRA194_CLK_PEX0_CORE_2M,
    TEGRA194_CLK_PEX0_CORE_3,
    TEGRA194_CLK_PEX0_CORE_3M,
    TEGRA194_CLK_PEX0_CORE_4,
    TEGRA194_CLK_PEX0_CORE_4M,
    TEGRA194_CLK_PEX1_CORE_5,
    TEGRA194_CLK_PEX1_CORE_5M,
    TEGRA194_CLK_PEX_REF1,
    TEGRA194_CLK_PEX_REF2,
    TEGRA194_CLK_PEX_SATA_USB_RX_BYP,
    TEGRA194_CLK_PEX_USB_PAD_PLL0_MGMT,
    TEGRA194_CLK_PEX_USB_PAD_PLL1_MGMT,
    TEGRA194_CLK_PEX_USB_PAD_PLL2_MGMT,
    TEGRA194_CLK_PEX_USB_PAD_PLL3_MGMT,
    TEGRA194_CLK_PLLA,
    TEGRA194_CLK_PLLA1,
    TEGRA194_CLK_PLLA1_OUT1,
    TEGRA194_CLK_PLLAON,
    TEGRA194_CLK_PLLA_OUT0,
    TEGRA194_CLK_PLLBPMPCAM,
    TEGRA194_CLK_PLLC,
    TEGRA194_CLK_PLLC2,
    TEGRA194_CLK_PLLC3,
    TEGRA194_CLK_PLLC4,
    TEGRA194_CLK_PLLC4_MUXED,
    TEGRA194_CLK_PLLC4_OUT,
    TEGRA194_CLK_PLLC4_OUT1,
    TEGRA194_CLK_PLLC4_OUT2,
    TEGRA194_CLK_PLLC4_VCO_DIV2,
    TEGRA194_CLK_PLLD,
    TEGRA194_CLK_PLLD2,
    TEGRA194_CLK_PLLD3,
    TEGRA194_CLK_PLLD4,
    TEGRA194_CLK_PLLDISPHUB,
    TEGRA194_CLK_PLLDISPHUB_DIV,
    TEGRA194_CLK_PLLDP,
    TEGRA194_CLK_PLLE,
    TEGRA194_CLK_PLLE_HPS,
    TEGRA194_CLK_PLLNVCSI,
    TEGRA194_CLK_PLLNVHS,
    TEGRA194_CLK_PLLNVHS_HPS,
    TEGRA194_CLK_PLLP,
    TEGRA194_CLK_PLLP_DIV17,
    TEGRA194_CLK_PLLP_OUT0,
    TEGRA194_CLK_PLLP_OUT5,
    TEGRA194_CLK_PLLREFE_VCOOUT,
    TEGRA194_CLK_PLLREFE_VCOOUT_GATED,
    TEGRA194_CLK_PVA0_AXI,
    TEGRA194_CLK_PVA0_CPU_AXI,
    TEGRA194_CLK_PVA0_VPS,
    TEGRA194_CLK_PVA0_VPS0,
    TEGRA194_CLK_PVA0_VPS1,
    TEGRA194_CLK_PVA1_AXI,
    TEGRA194_CLK_PVA1_CPU_AXI,
    TEGRA194_CLK_PVA1_VPS,
    TEGRA194_CLK_PVA1_VPS0,
    TEGRA194_CLK_PVA1_VPS1,
    TEGRA194_CLK_PWM1,
    TEGRA194_CLK_PWM2,
    TEGRA194_CLK_PWM3,
    TEGRA194_CLK_PWM4,
    TEGRA194_CLK_PWM5,
    TEGRA194_CLK_PWM6,
    TEGRA194_CLK_PWM7,
    TEGRA194_CLK_PWM8,
    TEGRA194_CLK_QSPI0,
    TEGRA194_CLK_QSPI0_PM,
    TEGRA194_CLK_QSPI1,
    TEGRA194_CLK_QSPI1_PM,
    TEGRA194_CLK_RCE_CPU_NIC,
    TEGRA194_CLK_RCE_NIC,
    TEGRA194_CLK_SATA,
    TEGRA194_CLK_SATA_OOB,
    TEGRA194_CLK_SCE_CPU_NIC,
    TEGRA194_CLK_SCE_NIC,
    TEGRA194_CLK_SDMMC1,
    TEGRA194_CLK_SDMMC3,
    TEGRA194_CLK_SDMMC4,
    TEGRA194_CLK_SDMMC_LEGACY_TM,
    TEGRA194_CLK_SE,
    TEGRA194_CLK_SE_FREE,
    TEGRA194_CLK_SLVSEC,
    TEGRA194_CLK_SLVSEC_PADCTRL,
    TEGRA194_CLK_SOC_THERM,
    TEGRA194_CLK_SOR0_OUT,
    TEGRA194_CLK_SOR0_PAD_CLKOUT,
    TEGRA194_CLK_SOR0_REF,
    TEGRA194_CLK_SOR1_OUT,
    TEGRA194_CLK_SOR1_PAD_CLKOUT,
    TEGRA194_CLK_SOR1_REF,
    TEGRA194_CLK_SOR2_OUT,
    TEGRA194_CLK_SOR2_PAD_CLKOUT,
    TEGRA194_CLK_SOR2_REF,
    TEGRA194_CLK_SOR3_OUT,
    TEGRA194_CLK_SOR3_PAD_CLKOUT,
    TEGRA194_CLK_SOR3_REF,
    TEGRA194_CLK_SOR_SAFE,
    TEGRA194_CLK_SPDIFIN_SYNC_INPUT,
    TEGRA194_CLK_SPI1,
    TEGRA194_CLK_SPI2,
    TEGRA194_CLK_SPI3,
    TEGRA194_CLK_SYNC_DMIC1,
    TEGRA194_CLK_SYNC_DMIC2,
    TEGRA194_CLK_SYNC_DMIC3,
    TEGRA194_CLK_SYNC_DMIC4,
    TEGRA194_CLK_SYNC_DSPK1,
    TEGRA194_CLK_SYNC_DSPK2,
    TEGRA194_CLK_SYNC_I2S1,
    TEGRA194_CLK_SYNC_I2S2,
    TEGRA194_CLK_SYNC_I2S3,
    TEGRA194_CLK_SYNC_I2S4,
    TEGRA194_CLK_SYNC_I2S5,
    TEGRA194_CLK_SYNC_I2S6,
    TEGRA194_CLK_TACH,
    TEGRA194_CLK_TSC,
    TEGRA194_CLK_TSC_REF,
    TEGRA194_CLK_TSEC,
    TEGRA194_CLK_TSECB,
    TEGRA194_CLK_TSENSOR,
    TEGRA194_CLK_UARTA,
    TEGRA194_CLK_UARTB,
    TEGRA194_CLK_UARTC,
    TEGRA194_CLK_UARTD,
    TEGRA194_CLK_UARTE,
    TEGRA194_CLK_UARTF,
    TEGRA194_CLK_UARTG,
    TEGRA194_CLK_UARTH,
    TEGRA194_CLK_UART_FST_MIPI_CAL,
    TEGRA194_CLK_UFSDEV_REF,
    TEGRA194_CLK_UFSHC,
    TEGRA194_CLK_UPHY_PLL3,
    TEGRA194_CLK_USB2_TRK,
    TEGRA194_CLK_UTMIPLL,
    TEGRA194_CLK_UTMIPLL_CLKOUT48,
    TEGRA194_CLK_UTMIPLL_CLKOUT480,
    TEGRA194_CLK_UTMIPLL_HPS,
    TEGRA194_CLK_VI,
    TEGRA194_CLK_VIC,
    TEGRA194_CLK_VI_CONST,
    TEGRA194_CLK_XUSB_CORE_DEV,
    TEGRA194_CLK_XUSB_CORE_HOST,
    TEGRA194_CLK_XUSB_CORE_MUX,
    TEGRA194_CLK_XUSB_CORE_SS,
    TEGRA194_CLK_XUSB_FALCON,
    TEGRA194_CLK_XUSB_FALCON_HOST,
    TEGRA194_CLK_XUSB_FALCON_SS,
    TEGRA194_CLK_XUSB_FS,
    TEGRA194_CLK_XUSB_FS_DEV,
    TEGRA194_CLK_XUSB_FS_HOST,
    TEGRA194_CLK_XUSB_PADCTL,
    TEGRA194_CLK_XUSB_SS,
    TEGRA194_CLK_XUSB_SS_DEV,
    TEGRA194_CLK_XUSB_SS_SUPERSPEED,
]

frac_clocks = [
    TEGRA194_CLK_ACTMON,
    TEGRA194_CLK_AHUB,
    TEGRA194_CLK_AON_APB,
    TEGRA194_CLK_AON_CPU_NIC,
    TEGRA194_CLK_AON_I2C_SLOW,
    TEGRA194_CLK_AON_TOUCH,
    TEGRA194_CLK_APE,
    TEGRA194_CLK_AUD_MCLK,
    TEGRA194_CLK_AXI_CBB,
    TEGRA194_CLK_BPMP_APB,
    TEGRA194_CLK_BPMP_CPU_NIC,
    TEGRA194_CLK_CAN1,
    TEGRA194_CLK_CAN2,
    TEGRA194_CLK_CVNAS,
    TEGRA194_CLK_DMIC1,
    TEGRA194_CLK_DMIC2,
    TEGRA194_CLK_DMIC3,
    TEGRA194_CLK_DMIC4,
    TEGRA194_CLK_DMIC5,
    TEGRA194_CLK_DSPK1,
    TEGRA194_CLK_DSPK2,
    TEGRA194_CLK_EMCSA,
    TEGRA194_CLK_EMCSB,
    TEGRA194_CLK_EMCSC,
    TEGRA194_CLK_EMCSD,
    TEGRA194_CLK_EQOS_AXI,
    TEGRA194_CLK_EQOS_PTP_REF,
    TEGRA194_CLK_EQOS_TX,
    TEGRA194_CLK_EXTPERIPH1,
    TEGRA194_CLK_EXTPERIPH2,
    TEGRA194_CLK_EXTPERIPH3,
    TEGRA194_CLK_EXTPERIPH4,
    TEGRA194_CLK_HDA,
    TEGRA194_CLK_HDA2CODEC_2X,
    TEGRA194_CLK_HOST1X,
    TEGRA194_CLK_I2C_SLOW,
    TEGRA194_CLK_I2S1,
    TEGRA194_CLK_I2S2,
    TEGRA194_CLK_I2S3,
    TEGRA194_CLK_I2S4,
    TEGRA194_CLK_I2S5,
    TEGRA194_CLK_I2S6,
    TEGRA194_CLK_ISP,
    TEGRA194_CLK_MAUD,
    TEGRA194_CLK_MPHY_CORE_PLL_FIXED,
    TEGRA194_CLK_MPHY_L0_RX_SYMB,
    TEGRA194_CLK_MPHY_TX_1MHZ_REF,
    TEGRA194_CLK_MSS_ENCRYPT,
    TEGRA194_CLK_NVCSI,
    TEGRA194_CLK_NVCSILP,
    TEGRA194_CLK_NVDEC,
    TEGRA194_CLK_NVDEC1,
    TEGRA194_CLK_NVDISPLAYHUB,
    TEGRA194_CLK_NVDISPLAY_P0,
    TEGRA194_CLK_NVDISPLAY_P1,
    TEGRA194_CLK_NVDISPLAY_P2,
    TEGRA194_CLK_NVDISPLAY_P3,
    TEGRA194_CLK_NVENC,
    TEGRA194_CLK_NVENC1,
    TEGRA194_CLK_NVHS_PLL0_MGMT,
    TEGRA194_CLK_NVHS_RX_BYP_REF,
    TEGRA194_CLK_NVJPG,
    TEGRA194_CLK_PEX_SATA_USB_RX_BYP,
    TEGRA194_CLK_PEX_USB_PAD_PLL0_MGMT,
    TEGRA194_CLK_PEX_USB_PAD_PLL1_MGMT,
    TEGRA194_CLK_PEX_USB_PAD_PLL2_MGMT,
    TEGRA194_CLK_PEX_USB_PAD_PLL3_MGMT,
    TEGRA194_CLK_PWM1,
    TEGRA194_CLK_PWM2,
    TEGRA194_CLK_PWM3,
    TEGRA194_CLK_PWM4,
    TEGRA194_CLK_PWM5,
    TEGRA194_CLK_PWM6,
    TEGRA194_CLK_PWM7,
    TEGRA194_CLK_PWM8,
    TEGRA194_CLK_QSPI0,
    TEGRA194_CLK_QSPI1,
    TEGRA194_CLK_RCE_CPU_NIC,
    TEGRA194_CLK_SATA,
    TEGRA194_CLK_SATA_OOB,
    TEGRA194_CLK_SCE_CPU_NIC,
    TEGRA194_CLK_SDMMC1,
    TEGRA194_CLK_SDMMC3,
    TEGRA194_CLK_SDMMC4,
    TEGRA194_CLK_SDMMC_LEGACY_TM,
    TEGRA194_CLK_SE,
    TEGRA194_CLK_SLVSEC_PADCTRL,
    TEGRA194_CLK_SOC_THERM,
    TEGRA194_CLK_SOR0_REF,
    TEGRA194_CLK_SOR1_REF,
    TEGRA194_CLK_SOR2_REF,
    TEGRA194_CLK_SOR3_REF,
    TEGRA194_CLK_SPI1,
    TEGRA194_CLK_SPI2,
    TEGRA194_CLK_SPI3,
    TEGRA194_CLK_TACH,
    TEGRA194_CLK_TSC,
    TEGRA194_CLK_TSEC,
    TEGRA194_CLK_TSECB,
    TEGRA194_CLK_TSENSOR,
    TEGRA194_CLK_UARTA,
    TEGRA194_CLK_UARTB,
    TEGRA194_CLK_UARTC,
    TEGRA194_CLK_UARTD,
    TEGRA194_CLK_UARTE,
    TEGRA194_CLK_UARTF,
    TEGRA194_CLK_UARTG,
    TEGRA194_CLK_UARTH,
    TEGRA194_CLK_UART_FST_MIPI_CAL,
    TEGRA194_CLK_UFSHC,
    TEGRA194_CLK_USB2_TRK,
    TEGRA194_CLK_VI,
    TEGRA194_CLK_VIC,
    TEGRA194_CLK_VI_CONST,
    TEGRA194_CLK_XUSB_CORE_DEV,
    TEGRA194_CLK_XUSB_CORE_MUX,
    TEGRA194_CLK_XUSB_FALCON,
    TEGRA194_CLK_XUSB_FS,
    TEGRA194_CLK_XUSB_SS,
]

plls = [
    TEGRA194_CLK_PLLC,
    TEGRA194_CLK_PLLC4,
    TEGRA194_CLK_PLLDP,
    TEGRA194_CLK_PLLE,
    TEGRA194_CLK_PLLNVHS,
]

parent_clocks = {
    TEGRA194_CLK_ACLK:              [ TEGRA194_CLK_PLLA1, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_ACTMON:            [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_AHUB:              [ TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_AON_CPU_NIC:       [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_AON_I2C_SLOW:      [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_AON_TOUCH:         [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_APE:               [ TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_AUD_MCLK:          [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_AXI_CBB:           [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC2, TEGRA194_CLK_PLLC4_MUXED, TEGRA194_CLK_CLK_M, TEGRA194_CLK_CLK_32K ],
    TEGRA194_CLK_BPMP_APB:          [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLBPMPCAM, TEGRA194_CLK_NAFLL_BPMP, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_BPMP_CPU_NIC:      [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLBPMPCAM, TEGRA194_CLK_NAFLL_BPMP, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_CAN1:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_CAN2:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_CSI_A:             [ TEGRA194_CLK_CSI_A_PAD, TEGRA194_CLK_PLLNVCSI ],
    TEGRA194_CLK_CSI_B:             [ TEGRA194_CLK_CSI_B_PAD, TEGRA194_CLK_PLLNVCSI ],
    TEGRA194_CLK_CSI_C:             [ TEGRA194_CLK_CSI_C_PAD, TEGRA194_CLK_PLLNVCSI ],
    TEGRA194_CLK_CSI_D:             [ TEGRA194_CLK_CSI_D_PAD, TEGRA194_CLK_PLLNVCSI ],
    TEGRA194_CLK_CSI_E:             [ TEGRA194_CLK_CSI_E_PAD, TEGRA194_CLK_PLLNVCSI ],
    TEGRA194_CLK_CSI_F:             [ TEGRA194_CLK_CSI_F_PAD, TEGRA194_CLK_PLLNVCSI ],
    TEGRA194_CLK_CSI_G:             [ TEGRA194_CLK_CSI_G_PAD, TEGRA194_CLK_PLLNVCSI ],
    TEGRA194_CLK_CSI_H:             [ TEGRA194_CLK_CSI_H_PAD, TEGRA194_CLK_PLLNVCSI ],
    TEGRA194_CLK_CVNAS:             [ TEGRA194_CLK_NAFLL_CVNAS, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_DLA0_CORE_MUX:     [ TEGRA194_CLK_NAFLL_DLA, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_DLA0_FALCON_MUX:   [ TEGRA194_CLK_NAFLL_DLA_FALCON, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_DLA1_CORE_MUX:     [ TEGRA194_CLK_NAFLL_DLA, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_DLA1_FALCON_MUX:   [ TEGRA194_CLK_NAFLL_DLA_FALCON, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_DMIC1:             [ TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_SYNC_DMIC1, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_DMIC2:             [ TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_SYNC_DMIC2, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_DMIC3:             [ TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_SYNC_DMIC3, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_DMIC4:             [ TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_SYNC_DMIC4, TEGRA194_CLK_CLK_M, TEGRA194_CLK_PLLP_OUT0 ],
    TEGRA194_CLK_DMIC5:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_DSPK1:             [ TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_SYNC_DSPK1, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_DSPK2:             [ TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_SYNC_DSPK2, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_EXTPERIPH1:        [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_EXTPERIPH2:        [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_EXTPERIPH3:        [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_EXTPERIPH4:        [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_HDA2CODEC_2X:      [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_HDA:               [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_HOST1X:            [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC2, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_I2C10:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_I2C1:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_I2C2:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_I2C3:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_I2C4:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_I2C6:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_I2C7:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M, TEGRA194_CLK_CLK_32K ],
    TEGRA194_CLK_I2C8:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_I2C9:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M, TEGRA194_CLK_CLK_32K ],
    TEGRA194_CLK_I2C_SLOW:          [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_I2S1:              [ TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_SYNC_I2S1, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_I2S2:              [ TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_SYNC_I2S2, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_I2S3:              [ TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_SYNC_I2S3, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_I2S4:              [ TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_SYNC_I2S4, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_I2S5:              [ TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_SYNC_I2S5, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_I2S6:              [ TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_PLLA1_OUT1, TEGRA194_CLK_SYNC_I2S6, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_ISP:               [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_NAFLL_ISP, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_MAUD:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_MSS_ENCRYPT:       [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_NVCSI:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLNVCSI, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_NVCSILP:           [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_NVDEC1:            [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_NAFLL_NVDEC1, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_NVDEC:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_NAFLL_NVDEC, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_NVDISPLAYHUB:      [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLDISPHUB, TEGRA194_CLK_CLK_M, TEGRA194_CLK_CLK_32K ],
    TEGRA194_CLK_NVDISPLAY_DISP:    [ TEGRA194_CLK_NVDISPLAY_P0, TEGRA194_CLK_NVDISPLAY_P1, TEGRA194_CLK_NVDISPLAY_P2, TEGRA194_CLK_NVDISPLAY_P3, TEGRA194_CLK_SOR_SAFE, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_NVDISPLAY_P0:      [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLD2, TEGRA194_CLK_PLLD3, TEGRA194_CLK_PLLD4, TEGRA194_CLK_CLK_M, TEGRA194_CLK_PLLD ],
    TEGRA194_CLK_NVDISPLAY_P1:      [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLD2, TEGRA194_CLK_PLLD3, TEGRA194_CLK_PLLD4, TEGRA194_CLK_CLK_M, TEGRA194_CLK_PLLD ],
    TEGRA194_CLK_NVDISPLAY_P2:      [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLD2, TEGRA194_CLK_PLLD3, TEGRA194_CLK_PLLD4, TEGRA194_CLK_CLK_M, TEGRA194_CLK_PLLD ],
    TEGRA194_CLK_NVDISPLAY_P3:      [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLD2, TEGRA194_CLK_PLLD3, TEGRA194_CLK_PLLD4, TEGRA194_CLK_CLK_M, TEGRA194_CLK_PLLD ],
    TEGRA194_CLK_NVENC1:            [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_NAFLL_NVENC1, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_NVENC:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_NAFLL_NVENC, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_NVJPG:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_NAFLL_NVJPG, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_NVLINK_SYS:        [ TEGRA194_CLK_CLK_M, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLREFE_VCOOUT_GATED ],
    TEGRA194_CLK_NVLINK_TX:         [ TEGRA194_CLK_CLK_M, TEGRA194_CLK_NVLINK_PLL_TXCLK ],
    TEGRA194_CLK_PLLC4_MUXED:       [ TEGRA194_CLK_PLLC4_OUT1, TEGRA194_CLK_PLLC4_OUT2, TEGRA194_CLK_PLLC4_VCO_DIV2 ],
    TEGRA194_CLK_PVA0_CPU_AXI:      [ TEGRA194_CLK_NAFLL_PVA_CORE, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_PVA0_VPS:          [ TEGRA194_CLK_NAFLL_PVA_VPS, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_PVA1_CPU_AXI:      [ TEGRA194_CLK_NAFLL_PVA_CORE, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_PVA1_VPS:          [ TEGRA194_CLK_NAFLL_PVA_VPS, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_PWM1:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_PWM2:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_PWM3:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_PWM4:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_PWM5:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_PWM6:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_PWM7:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_PWM8:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_QSPI0:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC2, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLC3, TEGRA194_CLK_PLLC4_MUXED, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_QSPI1:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC2, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLC3, TEGRA194_CLK_PLLC4_MUXED, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_RCE_CPU_NIC:       [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLBPMPCAM, TEGRA194_CLK_NAFLL_RCE, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_SATA:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_SATA_OOB:          [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_SCE_CPU_NIC:       [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLBPMPCAM, TEGRA194_CLK_NAFLL_SCE, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_SDMMC1:            [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC4_MUXED, TEGRA194_CLK_CLK_M, TEGRA194_CLK_CLK_32K ],
    TEGRA194_CLK_SDMMC3:            [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC4_MUXED, TEGRA194_CLK_CLK_M, TEGRA194_CLK_CLK_32K ],
    TEGRA194_CLK_SDMMC4:            [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC4, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_SDMMC_LEGACY_TM:   [ TEGRA194_CLK_PLLP_OUT0 ],
    TEGRA194_CLK_SE:                [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLBPMPCAM, TEGRA194_CLK_NAFLL_SE, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_SLVSEC_PADCTRL:    [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_SOC_THERM:         [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_SOR0_OUT:          [ TEGRA194_CLK_SOR_SAFE, TEGRA194_CLK_SOR0_PAD_CLKOUT, TEGRA194_CLK_SOR0_REF ],
    TEGRA194_CLK_SOR0_REF:          [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLD, TEGRA194_CLK_PLLD2, TEGRA194_CLK_PLLD3, TEGRA194_CLK_PLLD4, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_SOR1_OUT:          [ TEGRA194_CLK_SOR_SAFE, TEGRA194_CLK_SOR1_PAD_CLKOUT, TEGRA194_CLK_SOR1_REF ],
    TEGRA194_CLK_SOR1_REF:          [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLD, TEGRA194_CLK_PLLD2, TEGRA194_CLK_PLLD3, TEGRA194_CLK_PLLD4, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_SOR2_OUT:          [ TEGRA194_CLK_SOR_SAFE, TEGRA194_CLK_SOR2_PAD_CLKOUT, TEGRA194_CLK_SOR2_REF ],
    TEGRA194_CLK_SOR2_REF:          [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLD, TEGRA194_CLK_PLLD2, TEGRA194_CLK_PLLD3, TEGRA194_CLK_PLLD4, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_SOR3_OUT:          [ TEGRA194_CLK_SOR_SAFE, TEGRA194_CLK_SOR3_PAD_CLKOUT, TEGRA194_CLK_SOR3_REF ],
    TEGRA194_CLK_SOR3_REF:          [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLD, TEGRA194_CLK_PLLD2, TEGRA194_CLK_PLLD3, TEGRA194_CLK_PLLD4, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_SPI1:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_SPI2:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_SPI3:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_SYNC_DMIC1:        [ TEGRA194_CLK_SPDIFIN_SYNC_INPUT, TEGRA194_CLK_I2S1_SYNC_INPUT, TEGRA194_CLK_I2S2_SYNC_INPUT, TEGRA194_CLK_I2S3_SYNC_INPUT, TEGRA194_CLK_I2S4_SYNC_INPUT, TEGRA194_CLK_I2S5_SYNC_INPUT, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_I2S6_SYNC_INPUT ],
    TEGRA194_CLK_SYNC_DMIC2:        [ TEGRA194_CLK_SPDIFIN_SYNC_INPUT, TEGRA194_CLK_I2S1_SYNC_INPUT, TEGRA194_CLK_I2S2_SYNC_INPUT, TEGRA194_CLK_I2S3_SYNC_INPUT, TEGRA194_CLK_I2S4_SYNC_INPUT, TEGRA194_CLK_I2S5_SYNC_INPUT, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_I2S6_SYNC_INPUT ],
    TEGRA194_CLK_SYNC_DMIC3:        [ TEGRA194_CLK_SPDIFIN_SYNC_INPUT, TEGRA194_CLK_I2S1_SYNC_INPUT, TEGRA194_CLK_I2S2_SYNC_INPUT, TEGRA194_CLK_I2S3_SYNC_INPUT, TEGRA194_CLK_I2S4_SYNC_INPUT, TEGRA194_CLK_I2S5_SYNC_INPUT, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_I2S6_SYNC_INPUT ],
    TEGRA194_CLK_SYNC_DMIC4:        [ TEGRA194_CLK_SPDIFIN_SYNC_INPUT, TEGRA194_CLK_I2S1_SYNC_INPUT, TEGRA194_CLK_I2S2_SYNC_INPUT, TEGRA194_CLK_I2S3_SYNC_INPUT, TEGRA194_CLK_I2S4_SYNC_INPUT, TEGRA194_CLK_I2S5_SYNC_INPUT, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_I2S6_SYNC_INPUT ],
    TEGRA194_CLK_SYNC_DSPK1:        [ TEGRA194_CLK_SPDIFIN_SYNC_INPUT, TEGRA194_CLK_I2S1_SYNC_INPUT, TEGRA194_CLK_I2S2_SYNC_INPUT, TEGRA194_CLK_I2S3_SYNC_INPUT, TEGRA194_CLK_I2S4_SYNC_INPUT, TEGRA194_CLK_I2S5_SYNC_INPUT, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_I2S6_SYNC_INPUT ],
    TEGRA194_CLK_SYNC_DSPK2:        [ TEGRA194_CLK_SPDIFIN_SYNC_INPUT, TEGRA194_CLK_I2S1_SYNC_INPUT, TEGRA194_CLK_I2S2_SYNC_INPUT, TEGRA194_CLK_I2S3_SYNC_INPUT, TEGRA194_CLK_I2S4_SYNC_INPUT, TEGRA194_CLK_I2S5_SYNC_INPUT, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_I2S6_SYNC_INPUT ],
    TEGRA194_CLK_SYNC_I2S1:         [ TEGRA194_CLK_SPDIFIN_SYNC_INPUT, TEGRA194_CLK_I2S1_SYNC_INPUT, TEGRA194_CLK_I2S2_SYNC_INPUT, TEGRA194_CLK_I2S3_SYNC_INPUT, TEGRA194_CLK_I2S4_SYNC_INPUT, TEGRA194_CLK_I2S5_SYNC_INPUT, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_I2S6_SYNC_INPUT ],
    TEGRA194_CLK_SYNC_I2S2:         [ TEGRA194_CLK_SPDIFIN_SYNC_INPUT, TEGRA194_CLK_I2S1_SYNC_INPUT, TEGRA194_CLK_I2S2_SYNC_INPUT, TEGRA194_CLK_I2S3_SYNC_INPUT, TEGRA194_CLK_I2S4_SYNC_INPUT, TEGRA194_CLK_I2S5_SYNC_INPUT, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_I2S6_SYNC_INPUT ],
    TEGRA194_CLK_SYNC_I2S3:         [ TEGRA194_CLK_SPDIFIN_SYNC_INPUT, TEGRA194_CLK_I2S1_SYNC_INPUT, TEGRA194_CLK_I2S2_SYNC_INPUT, TEGRA194_CLK_I2S3_SYNC_INPUT, TEGRA194_CLK_I2S4_SYNC_INPUT, TEGRA194_CLK_I2S5_SYNC_INPUT, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_I2S6_SYNC_INPUT ],
    TEGRA194_CLK_SYNC_I2S4:         [ TEGRA194_CLK_SPDIFIN_SYNC_INPUT, TEGRA194_CLK_I2S1_SYNC_INPUT, TEGRA194_CLK_I2S2_SYNC_INPUT, TEGRA194_CLK_I2S3_SYNC_INPUT, TEGRA194_CLK_I2S4_SYNC_INPUT, TEGRA194_CLK_I2S5_SYNC_INPUT, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_I2S6_SYNC_INPUT ],
    TEGRA194_CLK_SYNC_I2S5:         [ TEGRA194_CLK_SPDIFIN_SYNC_INPUT, TEGRA194_CLK_I2S1_SYNC_INPUT, TEGRA194_CLK_I2S2_SYNC_INPUT, TEGRA194_CLK_I2S3_SYNC_INPUT, TEGRA194_CLK_I2S4_SYNC_INPUT, TEGRA194_CLK_I2S5_SYNC_INPUT, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_I2S6_SYNC_INPUT ],
    TEGRA194_CLK_SYNC_I2S6:         [ TEGRA194_CLK_SPDIFIN_SYNC_INPUT, TEGRA194_CLK_I2S1_SYNC_INPUT, TEGRA194_CLK_I2S2_SYNC_INPUT, TEGRA194_CLK_I2S3_SYNC_INPUT, TEGRA194_CLK_I2S4_SYNC_INPUT, TEGRA194_CLK_I2S5_SYNC_INPUT, TEGRA194_CLK_PLLA_OUT0, TEGRA194_CLK_I2S6_SYNC_INPUT ],
    TEGRA194_CLK_TACH:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M, TEGRA194_CLK_CLK_32K ],
    TEGRA194_CLK_TSC:               [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_TSEC:              [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_NAFLL_TSEC, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_TSECB:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_NAFLL_TSECB, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_TSENSOR:           [ TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_UARTA:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_UARTB:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_UARTC:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_PLLC4_MUXED, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_UARTD:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_UARTE:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_UARTF:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_UARTG:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLC, TEGRA194_CLK_PLLAON, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_OSC ],
    TEGRA194_CLK_UARTH:             [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_UART_FST_MIPI_CAL: [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_UFSHC:             [ TEGRA194_CLK_CLK_M, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLREFE_VCOOUT ],
    TEGRA194_CLK_VI:                [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_NAFLL_VI, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_VIC:               [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M, TEGRA194_CLK_NAFLL_VIC ],
    TEGRA194_CLK_VI_CONST:          [ TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_CLK_M ],
    TEGRA194_CLK_XUSB_CORE_DEV:     [ TEGRA194_CLK_CLK_M, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLREFE_VCOOUT ],
    TEGRA194_CLK_XUSB_CORE_MUX:     [ TEGRA194_CLK_CLK_M, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLREFE_VCOOUT ],
    TEGRA194_CLK_XUSB_FALCON:       [ TEGRA194_CLK_CLK_M, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_PLLREFE_VCOOUT ],
    TEGRA194_CLK_XUSB_FS:           [ TEGRA194_CLK_CLK_M, TEGRA194_CLK_UTMIPLL_CLKOUT48, TEGRA194_CLK_PLLP_OUT0, TEGRA194_CLK_UTMIPLL_CLKOUT480 ],
    TEGRA194_CLK_XUSB_SS:           [ TEGRA194_CLK_CLK_M, TEGRA194_CLK_PLLREFE_VCOOUT, TEGRA194_CLK_CLK_32K, TEGRA194_CLK_UTMIPLL_CLKOUT480 ],
}

# abi-t19x/mach-t194/regulator-t194.h
REGULATOR_RAIL_VDD_CPU0     = 0
REGULATOR_RAIL_VDD_CPU1     = 1
REGULATOR_RAIL_VDD_CORE     = 2
REGULATOR_RAIL_VDD_GPU      = 3
REGULATOR_RAIL_VDD_CV       = 4
REGULATOR_RAIL_DVDD_NVHS    = 5
REGULATOR_RAIL_VDD_AON      = 6
REGULATOR_RAIL_MAX          = 7

rails = [
    REGULATOR_RAIL_VDD_CPU0,
    REGULATOR_RAIL_VDD_CPU1,
    REGULATOR_RAIL_VDD_CORE,
    REGULATOR_RAIL_VDD_GPU,
    REGULATOR_RAIL_VDD_CV,
    REGULATOR_RAIL_DVDD_NVHS,
    REGULATOR_RAIL_VDD_AON,
    REGULATOR_RAIL_MAX,
]
