# Copyright (c) 2020-2021, NVIDIA CORPORATION. All rights reserved.
#
# NVIDIA CORPORATION and its licensors retain all intellectual property
# and proprietary rights in and to this software, related documentation
# and any modifications thereto.  Any use, reproduction, disclosure or
# distribution of this software and related documentation without an express
# license agreement from NVIDIA CORPORATION is strictly prohibited.

# abi-t23x/mach-t234/clk-t234.h
TEGRA234_CLK_ACTMON                  = 1
TEGRA234_CLK_ADSP                    = 2
TEGRA234_CLK_ADSPNEON                = 3
TEGRA234_CLK_AHUB                    = 4
TEGRA234_CLK_APB2APE                 = 5
TEGRA234_CLK_APE                     = 6
TEGRA234_CLK_AUD_MCLK                = 7
TEGRA234_CLK_AXI_CBB                 = 8
TEGRA234_CLK_CAN1                    = 9
TEGRA234_CLK_CAN1_HOST               = 10
TEGRA234_CLK_CAN2                    = 11
TEGRA234_CLK_CAN2_HOST               = 12
TEGRA234_CLK_CLK_M                   = 14
TEGRA234_CLK_DMIC1                   = 15
TEGRA234_CLK_DMIC2                   = 16
TEGRA234_CLK_DMIC3                   = 17
TEGRA234_CLK_DMIC4                   = 18
TEGRA234_CLK_DPAUX                   = 19
TEGRA234_CLK_NVJPG1                  = 20
TEGRA234_CLK_ACLK                    = 21
TEGRA234_CLK_MSS_ENCRYPT             = 22
TEGRA234_CLK_EQOS_RX_INPUT           = 23
TEGRA234_CLK_AON_APB                 = 25
TEGRA234_CLK_AON_NIC                 = 26
TEGRA234_CLK_AON_CPU_NIC             = 27
TEGRA234_CLK_PLLA1                   = 28
TEGRA234_CLK_DSPK1                   = 29
TEGRA234_CLK_DSPK2                   = 30
TEGRA234_CLK_EMC                     = 31
TEGRA234_CLK_EQOS_AXI                = 32
TEGRA234_CLK_EQOS_PTP_REF            = 33
TEGRA234_CLK_EQOS_RX                 = 34
TEGRA234_CLK_EQOS_TX                 = 35
TEGRA234_CLK_EXTPERIPH1              = 36
TEGRA234_CLK_EXTPERIPH2              = 37
TEGRA234_CLK_EXTPERIPH3              = 38
TEGRA234_CLK_EXTPERIPH4              = 39
TEGRA234_CLK_FUSE                    = 40
TEGRA234_CLK_GPC0CLK                 = 41
TEGRA234_CLK_GPU_PWR                 = 42
TEGRA234_CLK_HOST1X                  = 46
TEGRA234_CLK_XUSB_HS_HSICP           = 47
TEGRA234_CLK_I2C1                    = 48
TEGRA234_CLK_I2C2                    = 49
TEGRA234_CLK_I2C3                    = 50
TEGRA234_CLK_I2C4                    = 51
TEGRA234_CLK_I2C6                    = 52
TEGRA234_CLK_I2C7                    = 53
TEGRA234_CLK_I2C8                    = 54
TEGRA234_CLK_I2C9                    = 55
TEGRA234_CLK_I2S1                    = 56
TEGRA234_CLK_I2S1_SYNC_INPUT         = 57
TEGRA234_CLK_I2S2                    = 58
TEGRA234_CLK_I2S2_SYNC_INPUT         = 59
TEGRA234_CLK_I2S3                    = 60
TEGRA234_CLK_I2S3_SYNC_INPUT         = 61
TEGRA234_CLK_I2S4                    = 62
TEGRA234_CLK_I2S4_SYNC_INPUT         = 63
TEGRA234_CLK_I2S5                    = 64
TEGRA234_CLK_I2S5_SYNC_INPUT         = 65
TEGRA234_CLK_I2S6                    = 66
TEGRA234_CLK_I2S6_SYNC_INPUT         = 67
TEGRA234_CLK_ISP                     = 69
TEGRA234_CLK_EQOS_RX_M               = 70
TEGRA234_CLK_MAUD                    = 71
TEGRA234_CLK_MIPI_CAL                = 72
TEGRA234_CLK_MPHY_CORE_PLL_FIXED     = 73
TEGRA234_CLK_MPHY_L0_RX_ANA          = 74
TEGRA234_CLK_MPHY_L0_RX_LS_BIT       = 75
TEGRA234_CLK_MPHY_L0_RX_SYMB         = 76
TEGRA234_CLK_MPHY_L0_TX_LS_3XBIT     = 77
TEGRA234_CLK_MPHY_L0_TX_SYMB         = 78
TEGRA234_CLK_MPHY_L1_RX_ANA          = 79
TEGRA234_CLK_MPHY_TX_1MHZ_REF        = 80
TEGRA234_CLK_NVCSI                   = 81
TEGRA234_CLK_NVCSILP                 = 82
TEGRA234_CLK_NVDEC                   = 83
TEGRA234_CLK_HUB                     = 84
TEGRA234_CLK_DISP                    = 85
TEGRA234_CLK_NVDISPLAY_P0            = 86
TEGRA234_CLK_NVDISPLAY_P1            = 87
TEGRA234_CLK_DSC                     = 88
TEGRA234_CLK_NVENC                   = 89
TEGRA234_CLK_NVJPG                   = 90
TEGRA234_CLK_OSC                     = 91
TEGRA234_CLK_AON_TOUCH               = 92
TEGRA234_CLK_PLLA                    = 93
TEGRA234_CLK_PLLAON                  = 94
TEGRA234_CLK_PLLE                    = 100
TEGRA234_CLK_PLLP                    = 101
TEGRA234_CLK_PLLP_OUT0               = 102
TEGRA234_CLK_UTMIP_PLL               = 103
TEGRA234_CLK_PLLA_OUT0               = 104
TEGRA234_CLK_PWM1                    = 105
TEGRA234_CLK_PWM2                    = 106
TEGRA234_CLK_PWM3                    = 107
TEGRA234_CLK_PWM4                    = 108
TEGRA234_CLK_PWM5                    = 109
TEGRA234_CLK_PWM6                    = 110
TEGRA234_CLK_PWM7                    = 111
TEGRA234_CLK_PWM8                    = 112
TEGRA234_CLK_RCE_CPU_NIC             = 113
TEGRA234_CLK_RCE_NIC                 = 114
TEGRA234_CLK_AON_I2C_SLOW            = 117
TEGRA234_CLK_SCE_CPU_NIC             = 118
TEGRA234_CLK_SCE_NIC                 = 119
TEGRA234_CLK_SDMMC1                  = 120
TEGRA234_CLK_UPHY_PLL3               = 121
TEGRA234_CLK_SDMMC4                  = 123
TEGRA234_CLK_SE                      = 124
TEGRA234_CLK_SOR0_PLL_REF            = 125
TEGRA234_CLK_SOR0_REF                = 126
TEGRA234_CLK_SOR1_PLL_REF            = 127
TEGRA234_CLK_PRE_SOR0_REF            = 128
TEGRA234_CLK_SOR1_REF                = 129
TEGRA234_CLK_PRE_SOR1_REF            = 130
TEGRA234_CLK_SOR_SAFE                = 131
TEGRA234_CLK_DMIC5                   = 134
TEGRA234_CLK_SPI1                    = 135
TEGRA234_CLK_SPI2                    = 136
TEGRA234_CLK_SPI3                    = 137
TEGRA234_CLK_I2C_SLOW                = 138
TEGRA234_CLK_SYNC_DMIC1              = 139
TEGRA234_CLK_SYNC_DMIC2              = 140
TEGRA234_CLK_SYNC_DMIC3              = 141
TEGRA234_CLK_SYNC_DMIC4              = 142
TEGRA234_CLK_SYNC_DSPK1              = 143
TEGRA234_CLK_SYNC_DSPK2              = 144
TEGRA234_CLK_SYNC_I2S1               = 145
TEGRA234_CLK_SYNC_I2S2               = 146
TEGRA234_CLK_SYNC_I2S3               = 147
TEGRA234_CLK_SYNC_I2S4               = 148
TEGRA234_CLK_SYNC_I2S5               = 149
TEGRA234_CLK_SYNC_I2S6               = 150
TEGRA234_CLK_MPHY_FORCE_LS_MODE      = 151
TEGRA234_CLK_TACH0                   = 152
TEGRA234_CLK_TSEC                    = 153
TEGRA234_CLK_TSEC_PKA                = 154
TEGRA234_CLK_UARTA                   = 155
TEGRA234_CLK_UARTB                   = 156
TEGRA234_CLK_UARTC                   = 157
TEGRA234_CLK_UARTD                   = 158
TEGRA234_CLK_UARTE                   = 159
TEGRA234_CLK_UARTF                   = 160
TEGRA234_CLK_PEX1_C6_CORE            = 161
TEGRA234_CLK_UART_FST_MIPI_CAL       = 162
TEGRA234_CLK_UFSDEV_REF              = 163
TEGRA234_CLK_UFSHC                   = 164
TEGRA234_CLK_USB2_TRK                = 165
TEGRA234_CLK_VI                      = 166
TEGRA234_CLK_VIC                     = 167
TEGRA234_CLK_CSITE                   = 168
TEGRA234_CLK_IST                     = 169
TEGRA234_CLK_JTAG_INTFC_PRE_CG       = 170
TEGRA234_CLK_PEX2_C7_CORE            = 171
TEGRA234_CLK_PEX2_C8_CORE            = 172
TEGRA234_CLK_PEX2_C9_CORE            = 173
TEGRA234_CLK_DLA0_FALCON             = 174
TEGRA234_CLK_DLA0_CORE               = 175
TEGRA234_CLK_DLA1_FALCON             = 176
TEGRA234_CLK_DLA1_CORE               = 177
TEGRA234_CLK_SOR0                    = 178
TEGRA234_CLK_SOR1                    = 179
TEGRA234_CLK_SOR_PAD_INPUT           = 180
TEGRA234_CLK_PRE_SF0                 = 181
TEGRA234_CLK_SF0                     = 182
TEGRA234_CLK_SF1                     = 183
TEGRA234_CLK_DSI_PAD_INPUT           = 184
TEGRA234_CLK_PEX2_C10_CORE           = 187
TEGRA234_CLK_UARTI                   = 188
TEGRA234_CLK_UARTJ                   = 189
TEGRA234_CLK_UARTH                   = 190
TEGRA234_CLK_FUSE_SERIAL             = 191
TEGRA234_CLK_QSPI0_2X_PM             = 192
TEGRA234_CLK_QSPI1_2X_PM             = 193
TEGRA234_CLK_QSPI0_PM                = 194
TEGRA234_CLK_QSPI1_PM                = 195
TEGRA234_CLK_VI_CONST                = 196
TEGRA234_CLK_NAFLL_BPMP              = 197
TEGRA234_CLK_NAFLL_SCE               = 198
TEGRA234_CLK_NAFLL_NVDEC             = 199
TEGRA234_CLK_NAFLL_NVJPG             = 200
TEGRA234_CLK_NAFLL_TSEC              = 201
TEGRA234_CLK_NAFLL_VI                = 203
TEGRA234_CLK_NAFLL_SE                = 204
TEGRA234_CLK_NAFLL_NVENC             = 205
TEGRA234_CLK_NAFLL_ISP               = 206
TEGRA234_CLK_NAFLL_VIC               = 207
TEGRA234_CLK_NAFLL_AXICBB            = 209
TEGRA234_CLK_NAFLL_NVJPG1            = 210
TEGRA234_CLK_NAFLL_PVA0_CORE         = 211
TEGRA234_CLK_NAFLL_PVA0_VPS          = 212
TEGRA234_CLK_DBGAPB                  = 213
TEGRA234_CLK_NAFLL_RCE               = 214
TEGRA234_CLK_LA                      = 215
TEGRA234_CLK_PLLP_OUT_JTAG           = 216
TEGRA234_CLK_SDMMC4_AXICIF           = 217
TEGRA234_CLK_SDMMC_LEGACY_TM         = 219
TEGRA234_CLK_PEX0_C0_CORE            = 220
TEGRA234_CLK_PEX0_C1_CORE            = 221
TEGRA234_CLK_PEX0_C2_CORE            = 222
TEGRA234_CLK_PEX0_C3_CORE            = 223
TEGRA234_CLK_PEX0_C4_CORE            = 224
TEGRA234_CLK_PEX1_C5_CORE            = 225
TEGRA234_CLK_PEX0_C0_CORE_M          = 229
TEGRA234_CLK_PEX0_C1_CORE_M          = 230
TEGRA234_CLK_PEX0_C2_CORE_M          = 231
TEGRA234_CLK_PEX0_C3_CORE_M          = 232
TEGRA234_CLK_PEX0_C4_CORE_M          = 233
TEGRA234_CLK_PEX1_C5_CORE_M          = 234
TEGRA234_CLK_PEX1_C6_CORE_M          = 235
TEGRA234_CLK_GPC1CLK                 = 236
TEGRA234_CLK_PLLC4                   = 237
TEGRA234_CLK_PLLC4_OUT1              = 239
TEGRA234_CLK_PLLC4_OUT2              = 240
TEGRA234_CLK_PLLC4_MUXED             = 241
TEGRA234_CLK_PLLC4_VCO_DIV2          = 242
TEGRA234_CLK_PLLNVHS                 = 243
TEGRA234_CLK_PEX2_C7_CORE_M          = 244
TEGRA234_CLK_PEX2_C8_CORE_M          = 245
TEGRA234_CLK_PEX2_C9_CORE_M          = 246
TEGRA234_CLK_PEX2_C10_CORE_M         = 247
TEGRA234_CLK_MGBE0_RX_INPUT          = 248
TEGRA234_CLK_MGBE1_RX_INPUT          = 249
TEGRA234_CLK_MGBE2_RX_INPUT          = 250
TEGRA234_CLK_MGBE3_RX_INPUT          = 251
TEGRA234_CLK_PEX_SATA_USB_RX_BYP     = 254
TEGRA234_CLK_PEX_USB_PAD_PLL0_MGMT   = 255
TEGRA234_CLK_PEX_USB_PAD_PLL1_MGMT   = 256
TEGRA234_CLK_PEX_USB_PAD_PLL2_MGMT   = 257
TEGRA234_CLK_PEX_USB_PAD_PLL3_MGMT   = 258
TEGRA234_CLK_NVHS_RX_BYP_REF         = 263
TEGRA234_CLK_NVHS_PLL0_MGMT          = 264
TEGRA234_CLK_XUSB_CORE_DEV           = 265
TEGRA234_CLK_XUSB_CORE_MUX           = 266
TEGRA234_CLK_XUSB_CORE_HOST          = 267
TEGRA234_CLK_XUSB_CORE_SS            = 268
TEGRA234_CLK_XUSB_FALCON             = 269
TEGRA234_CLK_XUSB_FALCON_HOST        = 270
TEGRA234_CLK_XUSB_FALCON_SS          = 271
TEGRA234_CLK_XUSB_FS                 = 272
TEGRA234_CLK_XUSB_FS_HOST            = 273
TEGRA234_CLK_XUSB_FS_DEV             = 274
TEGRA234_CLK_XUSB_SS                 = 275
TEGRA234_CLK_XUSB_SS_DEV             = 276
TEGRA234_CLK_XUSB_SS_SUPERSPEED      = 277
TEGRA234_CLK_NAFLL_CLUSTER0          = 280
TEGRA234_CLK_NAFLL_CLUSTER1          = 281
TEGRA234_CLK_NAFLL_CLUSTER2          = 282
TEGRA234_CLK_CAN1_CORE               = 284
TEGRA234_CLK_CAN2_CORE               = 285
TEGRA234_CLK_PLLA1_OUT1              = 286
TEGRA234_CLK_PLLNVHS_HPS             = 287
TEGRA234_CLK_PLLREFE_VCOOUT          = 288
TEGRA234_CLK_CLK_32K                 = 289
TEGRA234_CLK_UTMIPLL_CLKOUT48        = 291
TEGRA234_CLK_UTMIPLL_CLKOUT480       = 292
TEGRA234_CLK_PLLNVCSI                = 294
TEGRA234_CLK_PVA0_CPU_AXI            = 295
TEGRA234_CLK_PVA0_VPS                = 297
TEGRA234_CLK_NAFLL_DLA0_CORE         = 299
TEGRA234_CLK_NAFLL_DLA0_FALCON       = 300
TEGRA234_CLK_NAFLL_DLA1_CORE         = 301
TEGRA234_CLK_NAFLL_DLA1_FALCON       = 302
TEGRA234_CLK_AON_UART_FST_MIPI_CAL   = 303
TEGRA234_CLK_GPUSYS                  = 304
TEGRA234_CLK_I2C5                    = 305
TEGRA234_CLK_FR_SE                   = 306
TEGRA234_CLK_BPMP_CPU_NIC            = 307
TEGRA234_CLK_BPMP_CPU                = 308
TEGRA234_CLK_TSC                     = 309
TEGRA234_CLK_EMCSA_MPLL              = 310
TEGRA234_CLK_EMCSB_MPLL              = 311
TEGRA234_CLK_EMCSC_MPLL              = 312
TEGRA234_CLK_EMCSD_MPLL              = 313
TEGRA234_CLK_PLLC                    = 314
TEGRA234_CLK_PLLC2                   = 315
TEGRA234_CLK_TSC_REF                 = 317
TEGRA234_CLK_FUSE_BURN               = 318
TEGRA234_CLK_PLLGBE                  = 319
TEGRA234_CLK_PLLGBE_HPS              = 320
TEGRA234_CLK_EMCSA_EMC               = 321
TEGRA234_CLK_EMCSB_EMC               = 322
TEGRA234_CLK_EMCSC_EMC               = 323
TEGRA234_CLK_EMCSD_EMC               = 324
TEGRA234_CLK_PLLE_HPS                = 326
TEGRA234_CLK_PLLREFE_VCOOUT_GATED    = 327
TEGRA234_CLK_PLLP_DIV17              = 328
TEGRA234_CLK_SOC_THERM               = 329
TEGRA234_CLK_TSENSE                  = 330
TEGRA234_CLK_FR_SEU1                 = 331
TEGRA234_CLK_NAFLL_OFA               = 333
TEGRA234_CLK_OFA                     = 334
TEGRA234_CLK_NAFLL_SEU1              = 335
TEGRA234_CLK_SEU1                    = 336
TEGRA234_CLK_SPI4                    = 337
TEGRA234_CLK_SPI5                    = 338
TEGRA234_CLK_DCE_CPU_NIC             = 339
TEGRA234_CLK_DCE_NIC                 = 340
TEGRA234_CLK_NAFLL_DCE               = 341
TEGRA234_CLK_MPHY_L0_RX_ANA_M        = 342
TEGRA234_CLK_MPHY_L1_RX_ANA_M        = 343
TEGRA234_CLK_MPHY_L0_TX_PRE_SYMB     = 344
TEGRA234_CLK_MPHY_L0_TX_LS_SYMB_DIV  = 345
TEGRA234_CLK_MPHY_L0_TX_2X_SYMB      = 346
TEGRA234_CLK_MPHY_L0_TX_HS_SYMB_DIV  = 347
TEGRA234_CLK_MPHY_L0_TX_LS_3XBIT_DIV = 348
TEGRA234_CLK_MPHY_L0_TX_MUX_SYMB_DIV = 349
TEGRA234_CLK_MPHY_L0_TX_SYMB_M       = 350
TEGRA234_CLK_MPHY_L0_RX_LS_SYMB_DIV  = 351
TEGRA234_CLK_MPHY_L0_RX_HS_SYMB_DIV  = 352
TEGRA234_CLK_MPHY_L0_RX_LS_BIT_DIV   = 353
TEGRA234_CLK_MPHY_L0_RX_MUX_SYMB_DIV = 354
TEGRA234_CLK_MPHY_L0_RX_SYMB_M       = 355
TEGRA234_CLK_MGBE0_RX_INPUT_M        = 357
TEGRA234_CLK_MGBE1_RX_INPUT_M        = 358
TEGRA234_CLK_MGBE2_RX_INPUT_M        = 359
TEGRA234_CLK_MGBE3_RX_INPUT_M        = 360
TEGRA234_CLK_MGBE0_RX_PCS_M          = 361
TEGRA234_CLK_MGBE1_RX_PCS_M          = 362
TEGRA234_CLK_MGBE2_RX_PCS_M          = 363
TEGRA234_CLK_MGBE3_RX_PCS_M          = 364
TEGRA234_CLK_TACH1                   = 365
TEGRA234_CLK_MGBES_APP               = 366
TEGRA234_CLK_UPHY_GBE_PLL2_TX_REF    = 367
TEGRA234_CLK_UPHY_GBE_PLL2_XDIG      = 368
TEGRA234_CLK_MGBE0_RX_PCS_INPUT      = 369
TEGRA234_CLK_MGBE1_RX_PCS_INPUT      = 370
TEGRA234_CLK_MGBE2_RX_PCS_INPUT      = 371
TEGRA234_CLK_MGBE3_RX_PCS_INPUT      = 372
TEGRA234_CLK_MGBE0_RX_PCS            = 373
TEGRA234_CLK_MGBE0_TX                = 374
TEGRA234_CLK_MGBE0_TX_PCS            = 375
TEGRA234_CLK_MGBE0_MAC_DIVIDER       = 376
TEGRA234_CLK_MGBE0_MAC               = 377
TEGRA234_CLK_MGBE0_MACSEC            = 378
TEGRA234_CLK_MGBE0_EEE_PCS           = 379
TEGRA234_CLK_MGBE0_APP               = 380
TEGRA234_CLK_MGBE0_PTP_REF           = 381
TEGRA234_CLK_MGBE1_RX_PCS            = 382
TEGRA234_CLK_MGBE1_TX                = 383
TEGRA234_CLK_MGBE1_TX_PCS            = 384
TEGRA234_CLK_MGBE1_MAC_DIVIDER       = 385
TEGRA234_CLK_MGBE1_MAC               = 386
TEGRA234_CLK_MGBE1_MACSEC            = 387
TEGRA234_CLK_MGBE1_EEE_PCS           = 388
TEGRA234_CLK_MGBE1_APP               = 389
TEGRA234_CLK_MGBE1_PTP_REF           = 390
TEGRA234_CLK_MGBE2_RX_PCS            = 391
TEGRA234_CLK_MGBE2_TX                = 392
TEGRA234_CLK_MGBE2_TX_PCS            = 393
TEGRA234_CLK_MGBE2_MAC_DIVIDER       = 394
TEGRA234_CLK_MGBE2_MAC               = 395
TEGRA234_CLK_MGBE2_MACSEC            = 396
TEGRA234_CLK_MGBE2_EEE_PCS           = 397
TEGRA234_CLK_MGBE2_APP               = 398
TEGRA234_CLK_MGBE2_PTP_REF           = 399
TEGRA234_CLK_MGBE3_RX_PCS            = 400
TEGRA234_CLK_MGBE3_TX                = 401
TEGRA234_CLK_MGBE3_TX_PCS            = 402
TEGRA234_CLK_MGBE3_MAC_DIVIDER       = 403
TEGRA234_CLK_MGBE3_MAC               = 404
TEGRA234_CLK_MGBE3_MACSEC            = 405
TEGRA234_CLK_MGBE3_EEE_PCS           = 406
TEGRA234_CLK_MGBE3_APP               = 407
TEGRA234_CLK_MGBE3_PTP_REF           = 408
TEGRA234_CLK_GBE_RX_BYP_REF          = 409
TEGRA234_CLK_GBE_PLL0_MGMT           = 410
TEGRA234_CLK_GBE_PLL1_MGMT           = 411
TEGRA234_CLK_GBE_PLL2_MGMT           = 412
TEGRA234_CLK_EQOS_MACSEC_RX          = 413
TEGRA234_CLK_EQOS_MACSEC_TX          = 414
TEGRA234_CLK_EQOS_TX_DIVIDER         = 415
TEGRA234_CLK_NVHS_PLL1_MGMT          = 416
TEGRA234_CLK_EMCHUB                  = 417
TEGRA234_CLK_I2S7_SYNC_INPUT         = 418
TEGRA234_CLK_SYNC_I2S7               = 419
TEGRA234_CLK_I2S7                    = 420
TEGRA234_CLK_I2S7_PAD_M              = 421
TEGRA234_CLK_I2S8_SYNC_INPUT         = 422
TEGRA234_CLK_SYNC_I2S8               = 423
TEGRA234_CLK_I2S8                    = 424
TEGRA234_CLK_I2S8_PAD_M              = 425
TEGRA234_CLK_NAFLL_GPC0              = 426
TEGRA234_CLK_NAFLL_GPC1              = 427
TEGRA234_CLK_NAFLL_GPUSYS            = 428
TEGRA234_CLK_NAFLL_DSU0              = 429
TEGRA234_CLK_NAFLL_DSU1              = 430
TEGRA234_CLK_NAFLL_DSU2              = 431
TEGRA234_CLK_SCE_CPU                 = 432
TEGRA234_CLK_RCE_CPU                 = 433
TEGRA234_CLK_DCE_CPU                 = 434
TEGRA234_CLK_DSIPLL_VCO              = 435
TEGRA234_CLK_DSIPLL_CLKOUTPN         = 436
TEGRA234_CLK_DSIPLL_CLKOUTA          = 437
TEGRA234_CLK_SPPLL0_VCO              = 438
TEGRA234_CLK_SPPLL0_CLKOUTPN         = 439
TEGRA234_CLK_SPPLL0_CLKOUTA          = 440
TEGRA234_CLK_SPPLL0_CLKOUTB          = 441
TEGRA234_CLK_SPPLL0_DIV10            = 442
TEGRA234_CLK_SPPLL0_DIV25            = 443
TEGRA234_CLK_SPPLL0_DIV27PN          = 444
TEGRA234_CLK_SPPLL1_VCO              = 445
TEGRA234_CLK_SPPLL1_CLKOUTPN         = 446
TEGRA234_CLK_SPPLL1_DIV27PN          = 447
TEGRA234_CLK_VPLL0_REF               = 448
TEGRA234_CLK_VPLL0                   = 449
TEGRA234_CLK_VPLL1                   = 450
TEGRA234_CLK_NVDISPLAY_P0_REF        = 451
TEGRA234_CLK_RG0                     = 452
TEGRA234_CLK_RG1                     = 453
TEGRA234_CLK_DISPPLL                 = 454
TEGRA234_CLK_DISPHUBPLL              = 455
TEGRA234_CLK_DSI_LP                  = 456
TEGRA234_CLK_AZA_2XBIT               = 457
TEGRA234_CLK_AZA_BIT                 = 458
TEGRA234_CLK_DSI_CORE                = 459
TEGRA234_CLK_DSI_PIXEL               = 460
TEGRA234_CLK_PRE_SOR0                = 461
TEGRA234_CLK_PRE_SOR1                = 462
TEGRA234_CLK_DP_LINK_REF             = 463
TEGRA234_CLK_SOR_LINKA_INPUT         = 464
TEGRA234_CLK_SOR_LINKA_AFIFO         = 465
TEGRA234_CLK_SOR_LINKA_AFIFO_M       = 466
TEGRA234_CLK_RG0_M                   = 467
TEGRA234_CLK_RG1_M                   = 468
TEGRA234_CLK_SOR0_M                  = 469
TEGRA234_CLK_SOR1_M                  = 470
TEGRA234_CLK_PLLHUB                  = 471
TEGRA234_CLK_MCHUB                   = 472
TEGRA234_CLK_EMCSA_MC                = 473
TEGRA234_CLK_EMCSB_MC                = 474
TEGRA234_CLK_EMCSC_MC                = 475
TEGRA234_CLK_EMCSD_MC                = 476

#abi-t23x/mach-t234/mail-t234.h
TEGRA234_DB_DCE    = 0x8000
TEGRA234_DB_RCE    = 0x4000
TEGRA234_DB_SCE    = 0x20
TEGRA234_DB_SPE    = 0x10
TEGRA234_DB_BPMP   = 0x8
TEGRA234_DB_DMCE   = 0x4
TEGRA234_DB_CPU_NS = 0x2
TEGRA234_DB_CPU_S  = 0x1

doorbells = TEGRA234_DB_DCE | \
            TEGRA234_DB_RCE | \
            TEGRA234_DB_SCE | \
            TEGRA234_DB_SPE | \
            TEGRA234_DB_DMCE | \
            TEGRA234_DB_CPU_NS | \
            TEGRA234_DB_CPU_S

enablers = doorbells | TEGRA234_DB_BPMP

clocks = [
    TEGRA234_CLK_ACTMON,
    TEGRA234_CLK_ADSP,
    TEGRA234_CLK_ADSPNEON,
    TEGRA234_CLK_AHUB,
    TEGRA234_CLK_APB2APE,
    TEGRA234_CLK_APE,
    TEGRA234_CLK_AUD_MCLK,
    TEGRA234_CLK_AXI_CBB,
    TEGRA234_CLK_CAN1,
    TEGRA234_CLK_CAN1_HOST,
    TEGRA234_CLK_CAN2,
    TEGRA234_CLK_CAN2_HOST,
    TEGRA234_CLK_CLK_M,
    TEGRA234_CLK_DMIC1,
    TEGRA234_CLK_DMIC2,
    TEGRA234_CLK_DMIC3,
    TEGRA234_CLK_DMIC4,
    TEGRA234_CLK_DPAUX,
    TEGRA234_CLK_NVJPG1,
    TEGRA234_CLK_ACLK,
    TEGRA234_CLK_MSS_ENCRYPT,
    TEGRA234_CLK_EQOS_RX_INPUT,
    TEGRA234_CLK_AON_APB,
    TEGRA234_CLK_AON_NIC,
    TEGRA234_CLK_AON_CPU_NIC,
    TEGRA234_CLK_PLLA1,
    TEGRA234_CLK_DSPK1,
    TEGRA234_CLK_DSPK2,
    TEGRA234_CLK_EMC,
    TEGRA234_CLK_EQOS_AXI,
    TEGRA234_CLK_EQOS_PTP_REF,
    TEGRA234_CLK_EQOS_RX,
    TEGRA234_CLK_EQOS_TX,
    TEGRA234_CLK_EXTPERIPH1,
    TEGRA234_CLK_EXTPERIPH2,
    TEGRA234_CLK_EXTPERIPH3,
    TEGRA234_CLK_EXTPERIPH4,
    TEGRA234_CLK_FUSE,
    TEGRA234_CLK_GPC0CLK,
    TEGRA234_CLK_GPU_PWR,
    TEGRA234_CLK_HOST1X,
    TEGRA234_CLK_XUSB_HS_HSICP,
    TEGRA234_CLK_I2C1,
    TEGRA234_CLK_I2C2,
    TEGRA234_CLK_I2C3,
    TEGRA234_CLK_I2C4,
    TEGRA234_CLK_I2C6,
    TEGRA234_CLK_I2C7,
    TEGRA234_CLK_I2C8,
    TEGRA234_CLK_I2C9,
    TEGRA234_CLK_I2S1,
    TEGRA234_CLK_I2S1_SYNC_INPUT,
    TEGRA234_CLK_I2S2,
    TEGRA234_CLK_I2S2_SYNC_INPUT,
    TEGRA234_CLK_I2S3,
    TEGRA234_CLK_I2S3_SYNC_INPUT,
    TEGRA234_CLK_I2S4,
    TEGRA234_CLK_I2S4_SYNC_INPUT,
    TEGRA234_CLK_I2S5,
    TEGRA234_CLK_I2S5_SYNC_INPUT,
    TEGRA234_CLK_I2S6,
    TEGRA234_CLK_I2S6_SYNC_INPUT,
    TEGRA234_CLK_ISP,
    TEGRA234_CLK_EQOS_RX_M,
    TEGRA234_CLK_MAUD,
    TEGRA234_CLK_MIPI_CAL,
    TEGRA234_CLK_MPHY_CORE_PLL_FIXED,
    TEGRA234_CLK_MPHY_L0_RX_ANA,
    TEGRA234_CLK_MPHY_L0_RX_LS_BIT,
    TEGRA234_CLK_MPHY_L0_RX_SYMB,
    TEGRA234_CLK_MPHY_L0_TX_LS_3XBIT,
    TEGRA234_CLK_MPHY_L0_TX_SYMB,
    TEGRA234_CLK_MPHY_L1_RX_ANA,
    TEGRA234_CLK_MPHY_TX_1MHZ_REF,
    TEGRA234_CLK_NVCSI,
    TEGRA234_CLK_NVCSILP,
    TEGRA234_CLK_NVDEC,
    TEGRA234_CLK_HUB,
    TEGRA234_CLK_DISP,
    TEGRA234_CLK_NVDISPLAY_P0,
    TEGRA234_CLK_NVDISPLAY_P1,
    TEGRA234_CLK_DSC,
    TEGRA234_CLK_NVENC,
    TEGRA234_CLK_NVJPG,
    TEGRA234_CLK_OSC,
    TEGRA234_CLK_AON_TOUCH,
    TEGRA234_CLK_PLLA,
    TEGRA234_CLK_PLLAON,
    TEGRA234_CLK_PLLE,
    TEGRA234_CLK_PLLP,
    TEGRA234_CLK_PLLP_OUT0,
    TEGRA234_CLK_UTMIP_PLL,
    TEGRA234_CLK_PLLA_OUT0,
    TEGRA234_CLK_PWM1,
    TEGRA234_CLK_PWM2,
    TEGRA234_CLK_PWM3,
    TEGRA234_CLK_PWM4,
    TEGRA234_CLK_PWM5,
    TEGRA234_CLK_PWM6,
    TEGRA234_CLK_PWM7,
    TEGRA234_CLK_PWM8,
    TEGRA234_CLK_RCE_CPU_NIC,
    TEGRA234_CLK_RCE_NIC,
    TEGRA234_CLK_AON_I2C_SLOW,
    TEGRA234_CLK_SCE_CPU_NIC,
    TEGRA234_CLK_SCE_NIC,
    TEGRA234_CLK_SDMMC1,
    TEGRA234_CLK_UPHY_PLL3,
    TEGRA234_CLK_SDMMC4,
    TEGRA234_CLK_SE,
    TEGRA234_CLK_SOR0_PLL_REF,
    TEGRA234_CLK_SOR0_REF,
    TEGRA234_CLK_SOR1_PLL_REF,
    TEGRA234_CLK_PRE_SOR0_REF,
    TEGRA234_CLK_SOR1_REF,
    TEGRA234_CLK_PRE_SOR1_REF,
    TEGRA234_CLK_SOR_SAFE,
    TEGRA234_CLK_DMIC5,
    TEGRA234_CLK_SPI1,
    TEGRA234_CLK_SPI2,
    TEGRA234_CLK_SPI3,
    TEGRA234_CLK_I2C_SLOW,
    TEGRA234_CLK_SYNC_DMIC1,
    TEGRA234_CLK_SYNC_DMIC2,
    TEGRA234_CLK_SYNC_DMIC3,
    TEGRA234_CLK_SYNC_DMIC4,
    TEGRA234_CLK_SYNC_DSPK1,
    TEGRA234_CLK_SYNC_DSPK2,
    TEGRA234_CLK_SYNC_I2S1,
    TEGRA234_CLK_SYNC_I2S2,
    TEGRA234_CLK_SYNC_I2S3,
    TEGRA234_CLK_SYNC_I2S4,
    TEGRA234_CLK_SYNC_I2S5,
    TEGRA234_CLK_SYNC_I2S6,
    TEGRA234_CLK_MPHY_FORCE_LS_MODE,
    TEGRA234_CLK_TACH0,
    TEGRA234_CLK_TSEC,
    TEGRA234_CLK_TSEC_PKA,
    TEGRA234_CLK_UARTA,
    TEGRA234_CLK_UARTB,
    TEGRA234_CLK_UARTC,
    TEGRA234_CLK_UARTD,
    TEGRA234_CLK_UARTE,
    TEGRA234_CLK_UARTF,
    TEGRA234_CLK_PEX1_C6_CORE,
    TEGRA234_CLK_UART_FST_MIPI_CAL,
    TEGRA234_CLK_UFSDEV_REF,
    TEGRA234_CLK_UFSHC,
    TEGRA234_CLK_USB2_TRK,
    TEGRA234_CLK_VI,
    TEGRA234_CLK_VIC,
    TEGRA234_CLK_CSITE,
    TEGRA234_CLK_IST,
    TEGRA234_CLK_JTAG_INTFC_PRE_CG,
    TEGRA234_CLK_PEX2_C7_CORE,
    TEGRA234_CLK_PEX2_C8_CORE,
    TEGRA234_CLK_PEX2_C9_CORE,
    TEGRA234_CLK_DLA0_FALCON,
    TEGRA234_CLK_DLA0_CORE,
    TEGRA234_CLK_DLA1_FALCON,
    TEGRA234_CLK_DLA1_CORE,
    TEGRA234_CLK_SOR0,
    TEGRA234_CLK_SOR1,
    TEGRA234_CLK_SOR_PAD_INPUT,
    TEGRA234_CLK_PRE_SF0,
    TEGRA234_CLK_SF0,
    TEGRA234_CLK_SF1,
    TEGRA234_CLK_DSI_PAD_INPUT,
    TEGRA234_CLK_PEX2_C10_CORE,
    TEGRA234_CLK_UARTI,
    TEGRA234_CLK_UARTJ,
    TEGRA234_CLK_UARTH,
    TEGRA234_CLK_FUSE_SERIAL,
    TEGRA234_CLK_QSPI0_2X_PM,
    TEGRA234_CLK_QSPI1_2X_PM,
    TEGRA234_CLK_QSPI0_PM,
    TEGRA234_CLK_QSPI1_PM,
    TEGRA234_CLK_VI_CONST,
    TEGRA234_CLK_NAFLL_BPMP,
    TEGRA234_CLK_NAFLL_SCE,
    TEGRA234_CLK_NAFLL_NVDEC,
    TEGRA234_CLK_NAFLL_NVJPG,
    TEGRA234_CLK_NAFLL_TSEC,
    TEGRA234_CLK_NAFLL_VI,
    TEGRA234_CLK_NAFLL_SE,
    TEGRA234_CLK_NAFLL_NVENC,
    TEGRA234_CLK_NAFLL_ISP,
    TEGRA234_CLK_NAFLL_VIC,
    TEGRA234_CLK_NAFLL_AXICBB,
    TEGRA234_CLK_NAFLL_NVJPG1,
    TEGRA234_CLK_NAFLL_PVA0_CORE,
    TEGRA234_CLK_NAFLL_PVA0_VPS,
    TEGRA234_CLK_DBGAPB,
    TEGRA234_CLK_NAFLL_RCE,
    TEGRA234_CLK_LA,
    TEGRA234_CLK_PLLP_OUT_JTAG,
    TEGRA234_CLK_SDMMC4_AXICIF,
    TEGRA234_CLK_SDMMC_LEGACY_TM,
    TEGRA234_CLK_PEX0_C0_CORE,
    TEGRA234_CLK_PEX0_C1_CORE,
    TEGRA234_CLK_PEX0_C2_CORE,
    TEGRA234_CLK_PEX0_C3_CORE,
    TEGRA234_CLK_PEX0_C4_CORE,
    TEGRA234_CLK_PEX1_C5_CORE,
    TEGRA234_CLK_PEX0_C0_CORE_M,
    TEGRA234_CLK_PEX0_C1_CORE_M,
    TEGRA234_CLK_PEX0_C2_CORE_M,
    TEGRA234_CLK_PEX0_C3_CORE_M,
    TEGRA234_CLK_PEX0_C4_CORE_M,
    TEGRA234_CLK_PEX1_C5_CORE_M,
    TEGRA234_CLK_PEX1_C6_CORE_M,
    TEGRA234_CLK_GPC1CLK,
    TEGRA234_CLK_PLLC4,
    TEGRA234_CLK_PLLC4_OUT1,
    TEGRA234_CLK_PLLC4_OUT2,
    TEGRA234_CLK_PLLC4_MUXED,
    TEGRA234_CLK_PLLC4_VCO_DIV2,
    TEGRA234_CLK_PLLNVHS,
    TEGRA234_CLK_PEX2_C7_CORE_M,
    TEGRA234_CLK_PEX2_C8_CORE_M,
    TEGRA234_CLK_PEX2_C9_CORE_M,
    TEGRA234_CLK_PEX2_C10_CORE_M,
    TEGRA234_CLK_MGBE0_RX_INPUT,
    TEGRA234_CLK_MGBE1_RX_INPUT,
    TEGRA234_CLK_MGBE2_RX_INPUT,
    TEGRA234_CLK_MGBE3_RX_INPUT,
    TEGRA234_CLK_PEX_SATA_USB_RX_BYP,
    TEGRA234_CLK_PEX_USB_PAD_PLL0_MGMT,
    TEGRA234_CLK_PEX_USB_PAD_PLL1_MGMT,
    TEGRA234_CLK_PEX_USB_PAD_PLL2_MGMT,
    TEGRA234_CLK_PEX_USB_PAD_PLL3_MGMT,
    TEGRA234_CLK_NVHS_RX_BYP_REF,
    TEGRA234_CLK_NVHS_PLL0_MGMT,
    TEGRA234_CLK_XUSB_CORE_DEV,
    TEGRA234_CLK_XUSB_CORE_MUX,
    TEGRA234_CLK_XUSB_CORE_HOST,
    TEGRA234_CLK_XUSB_CORE_SS,
    TEGRA234_CLK_XUSB_FALCON,
    TEGRA234_CLK_XUSB_FALCON_HOST,
    TEGRA234_CLK_XUSB_FALCON_SS,
    TEGRA234_CLK_XUSB_FS,
    TEGRA234_CLK_XUSB_FS_HOST,
    TEGRA234_CLK_XUSB_FS_DEV,
    TEGRA234_CLK_XUSB_SS,
    TEGRA234_CLK_XUSB_SS_DEV,
    TEGRA234_CLK_XUSB_SS_SUPERSPEED,
    TEGRA234_CLK_NAFLL_CLUSTER0,
    TEGRA234_CLK_NAFLL_CLUSTER1,
    TEGRA234_CLK_NAFLL_CLUSTER2,
    TEGRA234_CLK_CAN1_CORE,
    TEGRA234_CLK_CAN2_CORE,
    TEGRA234_CLK_PLLA1_OUT1,
    TEGRA234_CLK_PLLNVHS_HPS,
    TEGRA234_CLK_PLLREFE_VCOOUT,
    TEGRA234_CLK_CLK_32K,
    TEGRA234_CLK_UTMIPLL_CLKOUT48,
    TEGRA234_CLK_UTMIPLL_CLKOUT480,
    TEGRA234_CLK_PLLNVCSI,
    TEGRA234_CLK_PVA0_CPU_AXI,
    TEGRA234_CLK_PVA0_VPS,
    TEGRA234_CLK_NAFLL_DLA0_CORE,
    TEGRA234_CLK_NAFLL_DLA0_FALCON,
    TEGRA234_CLK_NAFLL_DLA1_CORE,
    TEGRA234_CLK_NAFLL_DLA1_FALCON,
    TEGRA234_CLK_AON_UART_FST_MIPI_CAL,
    TEGRA234_CLK_GPUSYS,
    TEGRA234_CLK_I2C5,
    TEGRA234_CLK_FR_SE,
    TEGRA234_CLK_BPMP_CPU_NIC,
    TEGRA234_CLK_BPMP_CPU,
    TEGRA234_CLK_TSC,
    TEGRA234_CLK_EMCSA_MPLL,
    TEGRA234_CLK_EMCSB_MPLL,
    TEGRA234_CLK_EMCSC_MPLL,
    TEGRA234_CLK_EMCSD_MPLL,
    TEGRA234_CLK_PLLC,
    TEGRA234_CLK_PLLC2,
    TEGRA234_CLK_TSC_REF,
    TEGRA234_CLK_FUSE_BURN,
    TEGRA234_CLK_PLLGBE,
    TEGRA234_CLK_PLLGBE_HPS,
    TEGRA234_CLK_EMCSA_EMC,
    TEGRA234_CLK_EMCSB_EMC,
    TEGRA234_CLK_EMCSC_EMC,
    TEGRA234_CLK_EMCSD_EMC,
    TEGRA234_CLK_PLLE_HPS,
    TEGRA234_CLK_PLLREFE_VCOOUT_GATED,
    TEGRA234_CLK_PLLP_DIV17,
    TEGRA234_CLK_SOC_THERM,
    TEGRA234_CLK_TSENSE,
    TEGRA234_CLK_FR_SEU1,
    TEGRA234_CLK_NAFLL_OFA,
    TEGRA234_CLK_OFA,
    TEGRA234_CLK_NAFLL_SEU1,
    TEGRA234_CLK_SEU1,
    TEGRA234_CLK_SPI4,
    TEGRA234_CLK_SPI5,
    TEGRA234_CLK_DCE_CPU_NIC,
    TEGRA234_CLK_DCE_NIC,
    TEGRA234_CLK_NAFLL_DCE,
    TEGRA234_CLK_MPHY_L0_RX_ANA_M,
    TEGRA234_CLK_MPHY_L1_RX_ANA_M,
    TEGRA234_CLK_MPHY_L0_TX_PRE_SYMB,
    TEGRA234_CLK_MPHY_L0_TX_LS_SYMB_DIV,
    TEGRA234_CLK_MPHY_L0_TX_2X_SYMB,
    TEGRA234_CLK_MPHY_L0_TX_HS_SYMB_DIV,
    TEGRA234_CLK_MPHY_L0_TX_LS_3XBIT_DIV,
    TEGRA234_CLK_MPHY_L0_TX_MUX_SYMB_DIV,
    TEGRA234_CLK_MPHY_L0_TX_SYMB_M,
    TEGRA234_CLK_MPHY_L0_RX_LS_SYMB_DIV,
    TEGRA234_CLK_MPHY_L0_RX_HS_SYMB_DIV,
    TEGRA234_CLK_MPHY_L0_RX_LS_BIT_DIV,
    TEGRA234_CLK_MPHY_L0_RX_MUX_SYMB_DIV,
    TEGRA234_CLK_MPHY_L0_RX_SYMB_M,
    TEGRA234_CLK_MGBE0_RX_INPUT_M,
    TEGRA234_CLK_MGBE1_RX_INPUT_M,
    TEGRA234_CLK_MGBE2_RX_INPUT_M,
    TEGRA234_CLK_MGBE3_RX_INPUT_M,
    TEGRA234_CLK_MGBE0_RX_PCS_M,
    TEGRA234_CLK_MGBE1_RX_PCS_M,
    TEGRA234_CLK_MGBE2_RX_PCS_M,
    TEGRA234_CLK_MGBE3_RX_PCS_M,
    TEGRA234_CLK_TACH1,
    TEGRA234_CLK_MGBES_APP,
    TEGRA234_CLK_UPHY_GBE_PLL2_TX_REF,
    TEGRA234_CLK_UPHY_GBE_PLL2_XDIG,
    TEGRA234_CLK_MGBE0_RX_PCS_INPUT,
    TEGRA234_CLK_MGBE1_RX_PCS_INPUT,
    TEGRA234_CLK_MGBE2_RX_PCS_INPUT,
    TEGRA234_CLK_MGBE3_RX_PCS_INPUT,
    TEGRA234_CLK_MGBE0_RX_PCS,
    TEGRA234_CLK_MGBE0_TX,
    TEGRA234_CLK_MGBE0_TX_PCS,
    TEGRA234_CLK_MGBE0_MAC_DIVIDER,
    TEGRA234_CLK_MGBE0_MAC,
    TEGRA234_CLK_MGBE0_MACSEC,
    TEGRA234_CLK_MGBE0_EEE_PCS,
    TEGRA234_CLK_MGBE0_APP,
    TEGRA234_CLK_MGBE0_PTP_REF,
    TEGRA234_CLK_MGBE1_RX_PCS,
    TEGRA234_CLK_MGBE1_TX,
    TEGRA234_CLK_MGBE1_TX_PCS,
    TEGRA234_CLK_MGBE1_MAC_DIVIDER,
    TEGRA234_CLK_MGBE1_MAC,
    TEGRA234_CLK_MGBE1_MACSEC,
    TEGRA234_CLK_MGBE1_EEE_PCS,
    TEGRA234_CLK_MGBE1_APP,
    TEGRA234_CLK_MGBE1_PTP_REF,
    TEGRA234_CLK_MGBE2_RX_PCS,
    TEGRA234_CLK_MGBE2_TX,
    TEGRA234_CLK_MGBE2_TX_PCS,
    TEGRA234_CLK_MGBE2_MAC_DIVIDER,
    TEGRA234_CLK_MGBE2_MAC,
    TEGRA234_CLK_MGBE2_MACSEC,
    TEGRA234_CLK_MGBE2_EEE_PCS,
    TEGRA234_CLK_MGBE2_APP,
    TEGRA234_CLK_MGBE2_PTP_REF,
    TEGRA234_CLK_MGBE3_RX_PCS,
    TEGRA234_CLK_MGBE3_TX,
    TEGRA234_CLK_MGBE3_TX_PCS,
    TEGRA234_CLK_MGBE3_MAC_DIVIDER,
    TEGRA234_CLK_MGBE3_MAC,
    TEGRA234_CLK_MGBE3_MACSEC,
    TEGRA234_CLK_MGBE3_EEE_PCS,
    TEGRA234_CLK_MGBE3_APP,
    TEGRA234_CLK_MGBE3_PTP_REF,
    TEGRA234_CLK_GBE_RX_BYP_REF,
    TEGRA234_CLK_GBE_PLL0_MGMT,
    TEGRA234_CLK_GBE_PLL1_MGMT,
    TEGRA234_CLK_GBE_PLL2_MGMT,
    TEGRA234_CLK_EQOS_MACSEC_RX,
    TEGRA234_CLK_EQOS_MACSEC_TX,
    TEGRA234_CLK_EQOS_TX_DIVIDER,
    TEGRA234_CLK_NVHS_PLL1_MGMT,
    TEGRA234_CLK_EMCHUB,
    TEGRA234_CLK_I2S7_SYNC_INPUT,
    TEGRA234_CLK_SYNC_I2S7,
    TEGRA234_CLK_I2S7,
    TEGRA234_CLK_I2S7_PAD_M,
    TEGRA234_CLK_I2S8_SYNC_INPUT,
    TEGRA234_CLK_SYNC_I2S8,
    TEGRA234_CLK_I2S8,
    TEGRA234_CLK_I2S8_PAD_M,
    TEGRA234_CLK_NAFLL_GPC0,
    TEGRA234_CLK_NAFLL_GPC1,
    TEGRA234_CLK_NAFLL_GPUSYS,
    TEGRA234_CLK_NAFLL_DSU0,
    TEGRA234_CLK_NAFLL_DSU1,
    TEGRA234_CLK_NAFLL_DSU2,
    TEGRA234_CLK_SCE_CPU,
    TEGRA234_CLK_RCE_CPU,
    TEGRA234_CLK_DCE_CPU,
    TEGRA234_CLK_DSIPLL_VCO,
    TEGRA234_CLK_DSIPLL_CLKOUTPN,
    TEGRA234_CLK_DSIPLL_CLKOUTA,
    TEGRA234_CLK_SPPLL0_VCO,
    TEGRA234_CLK_SPPLL0_CLKOUTPN,
    TEGRA234_CLK_SPPLL0_CLKOUTA,
    TEGRA234_CLK_SPPLL0_CLKOUTB,
    TEGRA234_CLK_SPPLL0_DIV10,
    TEGRA234_CLK_SPPLL0_DIV25,
    TEGRA234_CLK_SPPLL0_DIV27PN,
    TEGRA234_CLK_SPPLL1_VCO,
    TEGRA234_CLK_SPPLL1_CLKOUTPN,
    TEGRA234_CLK_SPPLL1_DIV27PN,
    TEGRA234_CLK_VPLL0_REF,
    TEGRA234_CLK_VPLL0,
    TEGRA234_CLK_VPLL1,
    TEGRA234_CLK_NVDISPLAY_P0_REF,
    TEGRA234_CLK_RG0,
    TEGRA234_CLK_RG1,
    TEGRA234_CLK_DISPPLL,
    TEGRA234_CLK_DISPHUBPLL,
    TEGRA234_CLK_DSI_LP,
    TEGRA234_CLK_AZA_2XBIT,
    TEGRA234_CLK_AZA_BIT,
    TEGRA234_CLK_DSI_CORE,
    TEGRA234_CLK_DSI_PIXEL,
    TEGRA234_CLK_PRE_SOR0,
    TEGRA234_CLK_PRE_SOR1,
    TEGRA234_CLK_DP_LINK_REF,
    TEGRA234_CLK_SOR_LINKA_INPUT,
    TEGRA234_CLK_SOR_LINKA_AFIFO,
    TEGRA234_CLK_SOR_LINKA_AFIFO_M,
    TEGRA234_CLK_RG0_M,
    TEGRA234_CLK_RG1_M,
    TEGRA234_CLK_SOR0_M,
    TEGRA234_CLK_SOR1_M,
    TEGRA234_CLK_PLLHUB,
    TEGRA234_CLK_MCHUB,
    TEGRA234_CLK_EMCSA_MC,
    TEGRA234_CLK_EMCSB_MC,
    TEGRA234_CLK_EMCSC_MC,
    TEGRA234_CLK_EMCSD_MC,
]

plls = [
    TEGRA234_CLK_PLLC4,
    TEGRA234_CLK_PLLE,
    TEGRA234_CLK_PLLGBE,
    TEGRA234_CLK_PLLNVHS,
    TEGRA234_CLK_SPPLL1_VCO,
]

parent_clocks = {
    TEGRA234_CLK_ACLK:                    [ TEGRA234_CLK_PLLA1, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_ACTMON:                  [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_AHUB:                    [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_AON_APB:                 [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_AON_CPU_NIC:             [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_AON_I2C_SLOW:            [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_AON_TOUCH:               [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_AON_UART_FST_MIPI_CAL:   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_APE:                     [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_AUD_MCLK:                [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_AXI_CBB:                 [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC2, TEGRA234_CLK_CLK_M, TEGRA234_CLK_CLK_32K ],
    TEGRA234_CLK_AZA_2XBIT:               [ TEGRA234_CLK_SPPLL0_DIV25, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_BPMP_CPU_NIC:            [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_NAFLL_BPMP, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_CAN1:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_CAN2:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_CSITE:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLREFE_VCOOUT_GATED, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M, TEGRA234_CLK_PLLC4_MUXED ],
    TEGRA234_CLK_DBGAPB:                  [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_DCE_CPU_NIC:             [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_NAFLL_DCE, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_DISP:                    [ TEGRA234_CLK_OSC, TEGRA234_CLK_DISPPLL, TEGRA234_CLK_SPPLL0_CLKOUTA ],
    TEGRA234_CLK_DLA0_CORE:               [ TEGRA234_CLK_NAFLL_DLA0_CORE, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_DLA0_FALCON:             [ TEGRA234_CLK_NAFLL_DLA0_FALCON, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_DLA1_CORE:               [ TEGRA234_CLK_NAFLL_DLA1_CORE, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_DLA1_FALCON:             [ TEGRA234_CLK_NAFLL_DLA1_FALCON, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_DMIC1:                   [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_SYNC_DMIC1, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SYNC_DMIC1:              [ TEGRA234_CLK_I2S1_SYNC_INPUT, TEGRA234_CLK_I2S2_SYNC_INPUT, TEGRA234_CLK_I2S3_SYNC_INPUT, TEGRA234_CLK_I2S4_SYNC_INPUT, TEGRA234_CLK_I2S5_SYNC_INPUT, TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_I2S6_SYNC_INPUT ],
    TEGRA234_CLK_DMIC2:                   [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_SYNC_DMIC2, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SYNC_DMIC2:              [ TEGRA234_CLK_I2S1_SYNC_INPUT, TEGRA234_CLK_I2S2_SYNC_INPUT, TEGRA234_CLK_I2S3_SYNC_INPUT, TEGRA234_CLK_I2S4_SYNC_INPUT, TEGRA234_CLK_I2S5_SYNC_INPUT, TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_I2S6_SYNC_INPUT ],
    TEGRA234_CLK_DMIC3:                   [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_SYNC_DMIC3, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SYNC_DMIC3:              [ TEGRA234_CLK_I2S1_SYNC_INPUT, TEGRA234_CLK_I2S2_SYNC_INPUT, TEGRA234_CLK_I2S3_SYNC_INPUT, TEGRA234_CLK_I2S4_SYNC_INPUT, TEGRA234_CLK_I2S5_SYNC_INPUT, TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_I2S6_SYNC_INPUT ],
    TEGRA234_CLK_DMIC4:                   [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_SYNC_DMIC4, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SYNC_DMIC4:              [ TEGRA234_CLK_I2S1_SYNC_INPUT, TEGRA234_CLK_I2S2_SYNC_INPUT, TEGRA234_CLK_I2S3_SYNC_INPUT, TEGRA234_CLK_I2S4_SYNC_INPUT, TEGRA234_CLK_I2S5_SYNC_INPUT, TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_I2S6_SYNC_INPUT ],
    TEGRA234_CLK_DMIC5:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_DP_LINK_REF:             [ TEGRA234_CLK_SPPLL0_CLKOUTPN, TEGRA234_CLK_SPPLL0_DIV27PN, TEGRA234_CLK_SPPLL1_CLKOUTPN, TEGRA234_CLK_SPPLL1_DIV27PN ],
    TEGRA234_CLK_DSI_CORE:                [ TEGRA234_CLK_OSC, TEGRA234_CLK_DSI_PAD_INPUT ],
    TEGRA234_CLK_DSI_LP:                  [ TEGRA234_CLK_OSC, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M, TEGRA234_CLK_CLK_32K ],
    TEGRA234_CLK_DSI_PIXEL:               [ TEGRA234_CLK_SF0, TEGRA234_CLK_DSI_PAD_INPUT ],
    TEGRA234_CLK_DSPK1:                   [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_SYNC_DSPK1, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SYNC_DSPK1:              [ TEGRA234_CLK_I2S1_SYNC_INPUT, TEGRA234_CLK_I2S2_SYNC_INPUT, TEGRA234_CLK_I2S3_SYNC_INPUT, TEGRA234_CLK_I2S4_SYNC_INPUT, TEGRA234_CLK_I2S5_SYNC_INPUT, TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_I2S6_SYNC_INPUT ],
    TEGRA234_CLK_DSPK2:                   [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_SYNC_DSPK2, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SYNC_DSPK2:              [ TEGRA234_CLK_I2S1_SYNC_INPUT, TEGRA234_CLK_I2S2_SYNC_INPUT, TEGRA234_CLK_I2S3_SYNC_INPUT, TEGRA234_CLK_I2S4_SYNC_INPUT, TEGRA234_CLK_I2S5_SYNC_INPUT, TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_I2S6_SYNC_INPUT ],
    TEGRA234_CLK_EXTPERIPH1:              [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_EXTPERIPH2:              [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_EXTPERIPH3:              [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_EXTPERIPH4:              [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_FR_SE:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_NAFLL_SE, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_FR_SEU1:                 [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_NAFLL_SEU1, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_HOST1X:                  [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC2, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_HUB:                     [ TEGRA234_CLK_OSC, TEGRA234_CLK_DISPHUBPLL, TEGRA234_CLK_SPPLL0_CLKOUTB ],
    TEGRA234_CLK_I2C1:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_I2C2:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_I2C3:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_I2C4:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_I2C6:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_I2C7:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_I2C8:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_I2C9:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_I2C_SLOW:                [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_I2S1:                    [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_SYNC_I2S1, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SYNC_I2S1:               [ TEGRA234_CLK_I2S1_SYNC_INPUT, TEGRA234_CLK_I2S2_SYNC_INPUT, TEGRA234_CLK_I2S3_SYNC_INPUT, TEGRA234_CLK_I2S4_SYNC_INPUT, TEGRA234_CLK_I2S5_SYNC_INPUT, TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_I2S6_SYNC_INPUT ],
    TEGRA234_CLK_I2S2:                    [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_SYNC_I2S2, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SYNC_I2S2:               [ TEGRA234_CLK_I2S1_SYNC_INPUT, TEGRA234_CLK_I2S2_SYNC_INPUT, TEGRA234_CLK_I2S3_SYNC_INPUT, TEGRA234_CLK_I2S4_SYNC_INPUT, TEGRA234_CLK_I2S5_SYNC_INPUT, TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_I2S6_SYNC_INPUT ],
    TEGRA234_CLK_I2S3:                    [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_SYNC_I2S3, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SYNC_I2S3:               [ TEGRA234_CLK_I2S1_SYNC_INPUT, TEGRA234_CLK_I2S2_SYNC_INPUT, TEGRA234_CLK_I2S3_SYNC_INPUT, TEGRA234_CLK_I2S4_SYNC_INPUT, TEGRA234_CLK_I2S5_SYNC_INPUT, TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_I2S6_SYNC_INPUT ],
    TEGRA234_CLK_I2S4:                    [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_SYNC_I2S4, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SYNC_I2S4:               [ TEGRA234_CLK_I2S1_SYNC_INPUT, TEGRA234_CLK_I2S2_SYNC_INPUT, TEGRA234_CLK_I2S3_SYNC_INPUT, TEGRA234_CLK_I2S4_SYNC_INPUT, TEGRA234_CLK_I2S5_SYNC_INPUT, TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_I2S6_SYNC_INPUT ],
    TEGRA234_CLK_I2S5:                    [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_SYNC_I2S5, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SYNC_I2S5:               [ TEGRA234_CLK_I2S1_SYNC_INPUT, TEGRA234_CLK_I2S2_SYNC_INPUT, TEGRA234_CLK_I2S3_SYNC_INPUT, TEGRA234_CLK_I2S4_SYNC_INPUT, TEGRA234_CLK_I2S5_SYNC_INPUT, TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_I2S6_SYNC_INPUT ],
    TEGRA234_CLK_I2S6:                    [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_SYNC_I2S6, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SYNC_I2S6:               [ TEGRA234_CLK_I2S1_SYNC_INPUT, TEGRA234_CLK_I2S2_SYNC_INPUT, TEGRA234_CLK_I2S3_SYNC_INPUT, TEGRA234_CLK_I2S4_SYNC_INPUT, TEGRA234_CLK_I2S5_SYNC_INPUT, TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_I2S6_SYNC_INPUT ],
    TEGRA234_CLK_I2S7:                    [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_SYNC_I2S7, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_I2S7_PAD_M:              [ TEGRA234_CLK_I2S7_SYNC_INPUT, TEGRA234_CLK_I2S7 ],
    TEGRA234_CLK_SYNC_I2S7:               [ TEGRA234_CLK_I2S7_SYNC_INPUT, TEGRA234_CLK_I2S8_SYNC_INPUT, TEGRA234_CLK_PLLA_OUT0 ],
    TEGRA234_CLK_I2S8:                    [ TEGRA234_CLK_PLLA_OUT0, TEGRA234_CLK_PLLA1_OUT1, TEGRA234_CLK_SYNC_I2S8, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_I2S8_PAD_M:              [ TEGRA234_CLK_I2S8_SYNC_INPUT, TEGRA234_CLK_I2S8 ],
    TEGRA234_CLK_SYNC_I2S8:               [ TEGRA234_CLK_I2S7_SYNC_INPUT, TEGRA234_CLK_I2S8_SYNC_INPUT, TEGRA234_CLK_PLLA_OUT0 ],
    TEGRA234_CLK_ISP:                     [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_NAFLL_ISP, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_IST:                     [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M, TEGRA234_CLK_PLLC4_MUXED ],
    TEGRA234_CLK_JTAG_INTFC_PRE_CG:       [ TEGRA234_CLK_OSC, TEGRA234_CLK_PLLP_OUT_JTAG ],
    TEGRA234_CLK_LA:                      [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLREFE_VCOOUT_GATED, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M, TEGRA234_CLK_PLLC4_MUXED ],
    TEGRA234_CLK_MAUD:                    [ TEGRA234_CLK_SPPLL0_DIV10, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_MGBE0_RX_PCS:            [ TEGRA234_CLK_MGBE0_RX_PCS_INPUT, TEGRA234_CLK_MGBE0_TX_PCS ],
    TEGRA234_CLK_MGBE1_RX_PCS:            [ TEGRA234_CLK_MGBE1_RX_PCS_INPUT, TEGRA234_CLK_MGBE1_TX_PCS ],
    TEGRA234_CLK_MGBE2_RX_PCS:            [ TEGRA234_CLK_MGBE2_RX_PCS_INPUT, TEGRA234_CLK_MGBE2_TX_PCS ],
    TEGRA234_CLK_MGBE3_RX_PCS:            [ TEGRA234_CLK_MGBE3_RX_PCS_INPUT, TEGRA234_CLK_MGBE3_TX_PCS ],
    TEGRA234_CLK_MGBES_APP:               [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M, TEGRA234_CLK_UTMIPLL_CLKOUT480 ],
    TEGRA234_CLK_MPHY_L0_RX_MUX_SYMB_DIV: [ TEGRA234_CLK_MPHY_L0_RX_LS_SYMB_DIV, TEGRA234_CLK_MPHY_L0_RX_HS_SYMB_DIV ],
    TEGRA234_CLK_MPHY_L0_TX_MUX_SYMB_DIV: [ TEGRA234_CLK_MPHY_L0_TX_LS_SYMB_DIV, TEGRA234_CLK_MPHY_L0_TX_HS_SYMB_DIV ],
    TEGRA234_CLK_MSS_ENCRYPT:             [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_NVCSI:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLNVCSI, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_NVCSILP:                 [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_NVDEC:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_NAFLL_NVDEC, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_NVDISPLAY_P0_REF:        [ TEGRA234_CLK_VPLL0, TEGRA234_CLK_DSIPLL_CLKOUTA ],
    TEGRA234_CLK_NVENC:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_NAFLL_NVENC, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_NVJPG1:                  [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_NAFLL_NVJPG1, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_NVJPG:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_NAFLL_NVJPG, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_OFA:                     [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_NAFLL_OFA, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_PLLC4_MUXED:             [ TEGRA234_CLK_PLLC4_OUT1, TEGRA234_CLK_PLLC4_OUT2, TEGRA234_CLK_PLLC4_VCO_DIV2 ],
    TEGRA234_CLK_PRE_SF0:                 [ TEGRA234_CLK_SOR_PAD_INPUT, TEGRA234_CLK_NVDISPLAY_P0 ],
    TEGRA234_CLK_PVA0_CPU_AXI:            [ TEGRA234_CLK_NAFLL_PVA0_CORE, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_PVA0_VPS:                [ TEGRA234_CLK_NAFLL_PVA0_VPS, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_PWM1:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_PWM2:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_PWM3:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_PWM4:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_PWM5:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_PWM6:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_PWM7:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_PWM8:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_QSPI0_2X_PM:             [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLC4_MUXED, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_QSPI1_2X_PM:             [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLC4_MUXED, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_RCE_CPU_NIC:             [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_NAFLL_RCE, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_RG0:                     [ TEGRA234_CLK_OSC, TEGRA234_CLK_NVDISPLAY_P0 ],
    TEGRA234_CLK_RG1:                     [ TEGRA234_CLK_OSC, TEGRA234_CLK_NVDISPLAY_P1 ],
    TEGRA234_CLK_SCE_CPU_NIC:             [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_NAFLL_SCE, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SDMMC1:                  [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC4_MUXED, TEGRA234_CLK_CLK_M, TEGRA234_CLK_CLK_32K ],
    TEGRA234_CLK_SDMMC4:                  [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC4, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SF0:                     [ TEGRA234_CLK_OSC, TEGRA234_CLK_PRE_SF0 ],
    TEGRA234_CLK_SF1:                     [ TEGRA234_CLK_OSC, TEGRA234_CLK_SOR_PAD_INPUT ],
    TEGRA234_CLK_SOC_THERM:               [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SOR0:                    [ TEGRA234_CLK_OSC, TEGRA234_CLK_PRE_SOR0 ],
    TEGRA234_CLK_SOR0_PLL_REF:            [ TEGRA234_CLK_VPLL0, TEGRA234_CLK_VPLL1 ],
    TEGRA234_CLK_SOR0_REF:                [ TEGRA234_CLK_PRE_SOR0_REF, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_SOR1:                    [ TEGRA234_CLK_OSC, TEGRA234_CLK_PRE_SOR1 ],
    TEGRA234_CLK_SOR1_PLL_REF:            [ TEGRA234_CLK_VPLL0, TEGRA234_CLK_VPLL1 ],
    TEGRA234_CLK_SOR1_REF:                [ TEGRA234_CLK_PRE_SOR1_REF, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_SOR_LINKA_AFIFO:         [ TEGRA234_CLK_OSC, TEGRA234_CLK_SOR_LINKA_INPUT ],
    TEGRA234_CLK_SPI1:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SPI2:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_SPI3:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SPI4:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_SPI5:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_TACH0:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_TACH1:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_TSC:                     [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_TSEC:                    [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_NAFLL_TSEC, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_TSEC_PKA:                [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_TSENSE:                  [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_UARTA:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_UARTB:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_UARTC:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_PLLC4_MUXED, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_UARTD:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_UARTE:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_UARTF:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_UARTH:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_UARTI:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_UARTJ:                   [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLC, TEGRA234_CLK_PLLAON, TEGRA234_CLK_PLLC4_MUXED, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_OSC ],
    TEGRA234_CLK_UART_FST_MIPI_CAL:       [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_UFSDEV_REF:              [ TEGRA234_CLK_OSC, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_UFSHC:                   [ TEGRA234_CLK_CLK_M, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLREFE_VCOOUT ],
    TEGRA234_CLK_VI:                      [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_NAFLL_VI, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_VIC:                     [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M, TEGRA234_CLK_NAFLL_VIC ],
    TEGRA234_CLK_VI_CONST:                [ TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_CLK_M ],
    TEGRA234_CLK_VPLL0_REF:               [ TEGRA234_CLK_OSC, TEGRA234_CLK_DSIPLL_CLKOUTA ],
    TEGRA234_CLK_XUSB_CORE_DEV:           [ TEGRA234_CLK_CLK_M, TEGRA234_CLK_PLLP_OUT0 ],
    TEGRA234_CLK_XUSB_CORE_MUX:           [ TEGRA234_CLK_CLK_M, TEGRA234_CLK_PLLP_OUT0 ],
    TEGRA234_CLK_XUSB_FALCON:             [ TEGRA234_CLK_CLK_M, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_PLLREFE_VCOOUT ],
    TEGRA234_CLK_XUSB_FS:                 [ TEGRA234_CLK_CLK_M, TEGRA234_CLK_UTMIPLL_CLKOUT48, TEGRA234_CLK_PLLP_OUT0, TEGRA234_CLK_UTMIPLL_CLKOUT480 ],
    TEGRA234_CLK_XUSB_SS:                 [ TEGRA234_CLK_CLK_M, TEGRA234_CLK_CLK_32K, TEGRA234_CLK_UTMIPLL_CLKOUT480 ],
}

regulators = []
