// Generated by dts-bundle-generator v9.5.1

import WebSocket$1 from 'isomorphic-ws';

export interface UartOpenedArgs {
	port: number;
	name: string;
	machineName: string;
}
export type UartOpenedCallback = (event: UartOpenedArgs) => void;
export interface LedStateChangedArgs {
	machineName: string;
	name: string;
	value: boolean;
}
export type LedStateChangedCallback = (event: LedStateChangedArgs) => void;
export interface ButtonStateChangedArgs {
	machineName: string;
	name: string;
	value: boolean;
}
export type ButtonStateChangedCallback = (event: ButtonStateChangedArgs) => void;
declare class Peripheral {
	readonly machine: string;
	readonly name: string;
	constructor(machine: string, name: string);
}
export declare enum SensorType {
	Temperature = "temperature",
	Acceleration = "acceleration",
	AngularRate = "angular-rate",
	Voltage = "voltage",
	ECG = "ecg",
	Humidity = "humidity",
	Pressure = "pressure",
	MagneticFluxDensity = "magnetic-flux-density"
}
export declare function SensorTypeFromString(value: string): SensorType | undefined;
export declare function GetSensorValue(type: SensorType, value: unknown, pretty?: boolean): SensorValue;
export declare class Sensor extends Peripheral {
	readonly types: SensorType[];
	constructor(machine: string, name: string, types: SensorType[]);
}
export declare abstract class SensorValue<SampleType = unknown> {
	abstract readonly sample: SampleType;
	abstract readonly unit: string;
	abstract get value(): SampleType;
	static fromValueChecked(_sample: unknown, _pretty: boolean): SensorValue;
}
export declare class RenodeProxySession extends EventTarget {
	private sessionSocket;
	private sessionUri?;
	private requestHandlers;
	private eventHandlers;
	private id;
	private defaultTimeout;
	private errorCallback;
	static tryConnect(wsUri: string, workspace: string): Promise<RenodeProxySession>;
	static fromWs(ws: WebSocket$1): RenodeProxySession;
	private constructor();
	set onError(cb: (event: WebSocket$1.ErrorEvent) => void);
	get sessionBase(): string | undefined;
	get socketReady(): boolean;
	startRenode(cwd?: string, gui?: boolean): Promise<void>;
	execMonitor(commands: string[]): Promise<void>;
	getUarts(machine: string): Promise<string[]>;
	getButtons(machine: string): Promise<string[]>;
	getLeds(machine: string): Promise<string[]>;
	setButtonValue(machine: string, peripheral: string, value: boolean): Promise<void>;
	getMachines(): Promise<string[]>;
	getSensors(machine: string, type?: SensorType): Promise<Sensor[]>;
	getSensorValue(sensor: Sensor, type: SensorType): Promise<SensorValue>;
	setSensorValue(sensor: Sensor, type: SensorType, value: SensorValue): Promise<void>;
	stopRenode(): Promise<void>;
	fetchZipToFs(zipUrl: string): Promise<{
		path: string;
	}>;
	fetchFileToFs(fileUrl: string): Promise<{
		path: string;
	}>;
	downloadFile(path: string): Promise<Uint8Array>;
	createDirectory(path: string): Promise<void>;
	sendFile(path: string, contents: Uint8Array): Promise<{
		path: string;
	}>;
	listFiles(path: string): Promise<{
		name: string;
		isfile: boolean;
		islink: boolean;
	}[]>;
	statFile(path: string): Promise<{
		size: number;
		isfile: boolean;
		ctime: number;
		mtime: number;
	}>;
	removeFile(path: string): Promise<{
		path: string;
	}>;
	moveFile(from: string, to: string): Promise<{
		from: string;
		to: string;
	}>;
	copyFile(from: string, to: string): Promise<{
		from: string;
		to: string;
	}>;
	replaceAnalyzers(path: string): Promise<{}>;
	filterEvents(allowedEvents: string[]): Promise<{}>;
	registerEventCallback(event: string, callback: EventCallback): void;
	unregisterEventCallback(event: string, callback: EventCallback): boolean;
	registerUartOpenedCallback(callback: UartOpenedCallback): EventCallback;
	unregisterUartOpenedCallback(callback: EventCallback): boolean;
	registerRenodeQuittedCallback(callback: EmptyEventCallback): void;
	unregisterRenodeQuittedCallback(callback: EmptyEventCallback): boolean;
	registerClearCommandCallback(callback: EmptyEventCallback): void;
	unregisterClearCommandCallback(callback: EmptyEventCallback): boolean;
	registerLedStateChangedCallback(callback: LedStateChangedCallback): EventCallback;
	unregisterLedStateChangedCallback(callback: EventCallback): boolean;
	registerButtonStateChangedCallback(callback: ButtonStateChangedCallback): EventCallback;
	unregisterButtonStateChangedCallback(callback: EventCallback): boolean;
	dispose(): void;
	private onData;
	private onResponse;
	private onEvent;
	private onClose;
	private sendSessionRequestTyped;
	private sendInner;
}
export type EventCallback = (event: object) => void;
export type EmptyEventCallback = () => void;

export {};
