#include "cpu-defs.h"

typedef enum {
#ifdef TARGET_X86_64
    RAX_64 = 0,
    RCX_64 = 2,
    RDX_64 = 3,
    RBX_64 = 1,
    RSP_64 = 4,
    RBP_64 = 5,
    RSI_64 = 6,
    RDI_64 = 7,
    R8_64 = 8,
    R9_64 = 9,
    R10_64 = 10,
    R11_64 = 11,
    R12_64 = 12,
    R13_64 = 13,
    R14_64 = 14,
    R15_64 = 15,
    RIP_64 = 16,
    EFLAGS_64 = 17,
    CS_64 = 18,
    SS_64 = 19,
    DS_64 = 20,
    ES_64 = 21,
    FS_64 = 22,
    GS_64 = 23,
    ST0_64 = 24,
    ST1_64 = 25,
    ST2_64 = 26,
    ST3_64 = 27,
    ST4_64 = 28,
    ST5_64 = 29,
    ST6_64 = 30,
    ST7_64 = 31,
    CR0_64 = 32,
    CR1_64 = 33,
    CR2_64 = 34,
    CR3_64 = 35,
    CR4_64 = 36,
#else
    EAX_32 = 0,
    ECX_32 = 1,
    EDX_32 = 2,
    EBX_32 = 3,
    ESP_32 = 4,
    EBP_32 = 5,
    ESI_32 = 6,
    EDI_32 = 7,
    EIP_32 = 8,
    EFLAGS_32 = 9,
    CS_32 = 10,
    SS_32 = 11,
    DS_32 = 12,
    ES_32 = 13,
    FS_32 = 14,
    GS_32 = 15,
    CR0_32 = 16,
    CR1_32 = 17,
    CR2_32 = 18,
    CR3_32 = 19,
    CR4_32 = 20
#endif
} Registers;
