*** Settings ***
Suite Setup                   Run Keywords
    ...                       Get Test Cases
    ...                       Create Status Directory

*** Variables ***
${repls_path}=                ${CURDIR}/../ci-output/repls
${dts_path}=                  ${CURDIR}/../ci-output/dts
${pattern}=                   *.repl.diff
${status_basedir}=            status
${not_ex_to_not_lo}=          not_existing-to-not_loading
${not_ex_to_lo}=              not_existing-to-loading
${not_lo_to_lo}=              not_loading-to-loading
${lo_to_not_lo}=              loading-to-not_loading
${lo_to_not_ex}=              loading-to-not_existing
${not_lo_to_not_ex}=          not_loading-to-not_existing

*** Keywords ***
Get Test Cases
    Setup
    # List Files In Directory returns the names of the repls, not full paths
    @{platforms}=             List Files In Directory  ${repls_path}/diffs  ${pattern}
    ${list_length}=           Get Length  ${platforms}
    # The CI script should have skipped running Renode if there are no repls with diffs
    Should Not Be True        ${list_length} == 0
    Set Suite Variable        ${platforms}

Create Status Directory
    Create Directory          ${status_basedir}

Try Load Platform
    [Arguments]               ${arg}
    ${repl_path}=             Remove String  ${arg}  .diff
    Execute Command           mach create
    ${result}=                Run Keyword And Ignore Error  Execute Command  machine LoadPlatformDescription "${repl_path}"
    Reset Emulation
    Return From Keyword       ${result}

Verify Repl Loading Status
    [Arguments]               ${arg}
    ${repl_name}=             Remove String  ${arg}  .diff
    ${board_name}=            Remove String  ${repl_name}  .repl

    ${old_repl_path}=         Set Variable  ${repls_path}/dashboard/${repl_name}
    ${new_repl_path}=         Set Variable  ${repls_path}/generated/${repl_name}
    ${old_result}=            Try Load Platform  ${old_repl_path}
    ${new_result}=            Try Load Platform  ${new_repl_path}
    ${old_size}=              Evaluate  os.stat("${old_repl_path}").st_size if os.path.exists("${old_repl_path}") else 0
    ${new_size}=              Evaluate  os.stat("${new_repl_path}").st_size if os.path.exists("${new_repl_path}") else 0

    IF  ${old_size} == 0 and "${new_result[0]}" == "PASS"
        # Since dts2repl-generated repls will always contain at least `// autogenerated`, if
        # a repl is empty here, we know it didn't exist and we filled it in with a blank one.
        Copy File             ${dts_path}/${board_name}.dts  ${status_basedir}/${not_ex_to_lo}/${board_name}/
        Copy File             ${new_repl_path}  ${status_basedir}/${not_ex_to_lo}/${board_name}/generated/
        Copy File             ${old_repl_path}  ${status_basedir}/${not_ex_to_lo}/${board_name}/dashboard/
    ELSE IF  ${old_size} == 0 and "${new_result[0]}" == "FAIL"
        Copy File             ${dts_path}/${board_name}.dts  ${status_basedir}/${not_ex_to_not_lo}/${board_name}/
        Copy File             ${new_repl_path}  ${status_basedir}/${not_ex_to_not_lo}/${board_name}/generated/
        Copy File             ${old_repl_path}  ${status_basedir}/${not_ex_to_not_lo}/${board_name}/dashboard/
    ELSE IF  "${old_result[0]}" == "PASS" and "${new_result[0]}" == "FAIL"
        # Regression
        Copy File             ${dts_path}/${board_name}.dts  ${status_basedir}/${lo_to_not_lo}/${board_name}/
        Copy File             ${new_repl_path}  ${status_basedir}/${lo_to_not_lo}/${board_name}/generated/
        Copy File             ${old_repl_path}  ${status_basedir}/${lo_to_not_lo}/${board_name}/dashboard/
    ELSE IF  "${old_result[0]}" == "FAIL" and "${new_result[0]}" == "PASS"
        Copy File             ${dts_path}/${board_name}.dts  ${status_basedir}/${not_lo_to_lo}/${board_name}/
        Copy File             ${new_repl_path}  ${status_basedir}/${not_lo_to_lo}/${board_name}/generated/
        Copy File             ${old_repl_path}  ${status_basedir}/${not_lo_to_lo}/${board_name}/dashboard/
    ELSE IF  "${old_result[0]}" == "FAIL" and "${new_size}" == 0
        Copy File             ${dts_path}/${board_name}.dts  ${status_basedir}/${not_lo_to_not_ex}/${board_name}/
        Copy File             ${new_repl_path}  ${status_basedir}/${not_lo_to_not_ex}/${board_name}/generated/
        Copy File             ${old_repl_path}  ${status_basedir}/${not_lo_to_not_ex}/${board_name}/dashboard/
    ELSE IF  "${old_result[0]}" == "PASS" and "${new_size}" == 0
        Copy File             ${dts_path}/${board_name}.dts  ${status_basedir}/${lo_to_not_ex}/${board_name}/
        Copy File             ${new_repl_path}  ${status_basedir}/${lo_to_not_ex}/${board_name}/generated/
        Copy File             ${old_repl_path}  ${status_basedir}/${lo_to_not_ex}/${board_name}/dashboard/
    END

*** Test Cases ***
Should Load Repls
    # This tests uses templates as it tests every item on the list, even if a prior one failed
    # and produces an aggregated failure summary
    [Template]  Verify Repl Loading Status
    FOR  ${test}  IN  @{platforms}
        ${test}
    END
