---
name: Bug report
about: Create a report to point us to an issue with the current codebase
---

Thanks for taking the time to file an issue for Renode!

Please familiarize yourself with our [Contributing guidelines](https://github.com/renode/renode/blob/master/CONTRIBUTING.md) first.

### Description

A clear and concise description of what the issue is about.

### Expected behaviour

What you expected to happen, and what is happening instead.

### How to reproduce?

We provide an [Issue reproduction template repository](https://github.com/renode/renode-issue-reproduction-template), which is the best way to show us how to reproduce your issue.

If it makes sense in the context of your issue, please create your own repository using this template and adapt the test files until you see the test failing as you expect.
If you know what the fix should be, you can also create a branch showing the fix and a passing test.

Link this repository here to let us understand your issue easily.

If you find it difficult to create such a repository, or it's not a viable way of reproducing your problem, please provide all the necessary details here: ``repl``, ``resc``, ``robot`` files, binaries, logs etc.
Please keep in mind that this route may require more back-and-forth communication to establish the underlying cause of the problem.

### Environment

Please, provide the following information:

- OS
- Renode version (with commit SHA)

### Additional information

Please add all the information you feel is relevant but not clearly visible in the reproduction repo or otherwise.

### Do you plan to address this issue and file a PR?

Please let us know if you want to work on this yourself or need support.
