/* Xtensa configuration-specific ISA information.

   Copyright (c) 2003-2010 Tensilica Inc.

   Permission is hereby granted, free of charge, to any person obtaining
   a copy of this software and associated documentation files (the
   "Software"), to deal in the Software without restriction, including
   without limitation the rights to use, copy, modify, merge, publish,
   distribute, sublicense, and/or sell copies of the Software, and to
   permit persons to whom the Software is furnished to do so, subject to
   the following conditions:

   The above copyright notice and this permission notice shall be included
   in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
   CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
   TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
   SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.  */

#include "xtensa-isa.h"
#include "xtensa-isa-internal.h"


/* Sysregs.  */

static xtensa_sysreg_internal sysregs[] = {
  { "LBEG", 0, 0 },
  { "LEND", 1, 0 },
  { "LCOUNT", 2, 0 },
  { "BR", 4, 0 },
  { "MMID", 89, 0 },
  { "DDR", 104, 0 },
  { "176", 176, 0 },
  { "208", 208, 0 },
  { "INTERRUPT", 226, 0 },
  { "INTCLEAR", 227, 0 },
  { "CCOUNT", 234, 0 },
  { "PRID", 235, 0 },
  { "ICOUNT", 236, 0 },
  { "CCOMPARE0", 240, 0 },
  { "CCOMPARE1", 241, 0 },
  { "VECBASE", 231, 0 },
  { "EPC1", 177, 0 },
  { "EPC2", 178, 0 },
  { "EPC3", 179, 0 },
  { "EPC4", 180, 0 },
  { "EPC5", 181, 0 },
  { "EPC6", 182, 0 },
  { "EXCSAVE1", 209, 0 },
  { "EXCSAVE2", 210, 0 },
  { "EXCSAVE3", 211, 0 },
  { "EXCSAVE4", 212, 0 },
  { "EXCSAVE5", 213, 0 },
  { "EXCSAVE6", 214, 0 },
  { "EPS2", 194, 0 },
  { "EPS3", 195, 0 },
  { "EPS4", 196, 0 },
  { "EPS5", 197, 0 },
  { "EPS6", 198, 0 },
  { "EXCCAUSE", 232, 0 },
  { "DEPC", 192, 0 },
  { "EXCVADDR", 238, 0 },
  { "WINDOWBASE", 72, 0 },
  { "WINDOWSTART", 73, 0 },
  { "SAR", 3, 0 },
  { "LITBASE", 5, 0 },
  { "PS", 230, 0 },
  { "INTENABLE", 228, 0 },
  { "DBREAKA0", 144, 0 },
  { "DBREAKC0", 160, 0 },
  { "DBREAKA1", 145, 0 },
  { "DBREAKC1", 161, 0 },
  { "IBREAKA0", 128, 0 },
  { "IBREAKA1", 129, 0 },
  { "IBREAKENABLE", 96, 0 },
  { "ICOUNTLEVEL", 237, 0 },
  { "DEBUGCAUSE", 233, 0 },
  { "CPENABLE", 224, 0 },
  { "SCOMPARE1", 12, 0 },
  { "ATOMCTL", 99, 0 },
  { "THREADPTR", 231, 1 },
  { "FCR", 232, 1 },
  { "FSR", 233, 1 },
  { "EXPSTATE", 0, 1 },
  { "SOV", 1, 1 },
  { "SAT_MODE", 2, 1 },
  { "SAR0", 3, 1 },
  { "SAR1", 4, 1 },
  { "SAR2", 5, 1 },
  { "SAR3", 6, 1 },
  { "HSAR0", 7, 1 },
  { "HSAR1", 8, 1 },
  { "HSAR2", 9, 1 },
  { "HSAR3", 10, 1 },
  { "MAX_REG_0", 11, 1 },
  { "MAX_REG_1", 12, 1 },
  { "MAX_REG_2", 13, 1 },
  { "MAX_REG_3", 14, 1 },
  { "ARG_MAX_REG_0", 15, 1 },
  { "ARG_MAX_REG_1", 16, 1 },
  { "ARG_MAX_REG_2", 17, 1 },
  { "ARG_MAX_REG_3", 18, 1 },
  { "NCO_COUNTER_0", 19, 1 },
  { "NCO_COUNTER_1", 20, 1 },
  { "NCO_COUNTER_2", 21, 1 },
  { "NCO_COUNTER_3", 22, 1 },
  { "INTERP_EXT_N", 23, 1 },
  { "INTERP_EXT_L", 24, 1 },
  { "LLR_BUF_0", 25, 1 },
  { "LLR_BUF_1", 26, 1 },
  { "LLR_BUF_2", 27, 1 },
  { "LLR_BUF_3", 28, 1 },
  { "LLR_BUF_4", 29, 1 },
  { "LLR_BUF_5", 30, 1 },
  { "LLR_BUF_6", 31, 1 },
  { "LLR_BUF_7", 32, 1 },
  { "LLR_BUF_8", 33, 1 },
  { "LLR_BUF_9", 34, 1 },
  { "LLR_BUF_10", 35, 1 },
  { "LLR_BUF_11", 36, 1 },
  { "LLR_BUF_12", 37, 1 },
  { "LLR_BUF_13", 38, 1 },
  { "LLR_BUF_14", 39, 1 },
  { "LLR_BUF_15", 40, 1 },
  { "LLR_BUF_16", 41, 1 },
  { "LLR_BUF_17", 42, 1 },
  { "LLR_BUF_18", 43, 1 },
  { "LLR_BUF_19", 44, 1 },
  { "LLR_BUF_20", 45, 1 },
  { "LLR_BUF_21", 46, 1 },
  { "LLR_BUF_22", 47, 1 },
  { "LLR_BUF_23", 48, 1 },
  { "SMOD_BUF_0", 49, 1 },
  { "SMOD_BUF_1", 50, 1 },
  { "SMOD_BUF_2", 51, 1 },
  { "SMOD_BUF_3", 52, 1 },
  { "SMOD_BUF_4", 53, 1 },
  { "SMOD_BUF_5", 54, 1 },
  { "SMOD_BUF_6", 55, 1 },
  { "SMOD_BUF_7", 56, 1 },
  { "WEIGHT_REG", 57, 1 },
  { "SCALE_REG", 58, 1 },
  { "LLR_POS", 59, 1 },
  { "SMOD_POS", 60, 1 },
  { "PERM_REG", 61, 1 },
  { "SMOD_OFFSET_TABLE_0", 62, 1 },
  { "SMOD_OFFSET_TABLE_1", 63, 1 },
  { "SMOD_OFFSET_TABLE_2", 64, 1 },
  { "SMOD_OFFSET_TABLE_3", 65, 1 },
  { "PHASOR_N", 66, 1 },
  { "PHASOR_OFFSET", 67, 1 }
};

#define NUM_SYSREGS 125
#define MAX_SPECIAL_REG 241
#define MAX_USER_REG 233


/* Processor states.  */

static xtensa_state_internal states[] = {
  { "LCOUNT", 32, 0 },
  { "PC", 32, 0 },
  { "ICOUNT", 32, 0 },
  { "DDR", 32, 0 },
  { "INTERRUPT", 13, 0 },
  { "CCOUNT", 32, 0 },
  { "XTSYNC", 1, 0 },
  { "VECBASE", 22, 0 },
  { "EPC1", 32, 0 },
  { "EPC2", 32, 0 },
  { "EPC3", 32, 0 },
  { "EPC4", 32, 0 },
  { "EPC5", 32, 0 },
  { "EPC6", 32, 0 },
  { "EXCSAVE1", 32, 0 },
  { "EXCSAVE2", 32, 0 },
  { "EXCSAVE3", 32, 0 },
  { "EXCSAVE4", 32, 0 },
  { "EXCSAVE5", 32, 0 },
  { "EXCSAVE6", 32, 0 },
  { "EPS2", 13, 0 },
  { "EPS3", 13, 0 },
  { "EPS4", 13, 0 },
  { "EPS5", 13, 0 },
  { "EPS6", 13, 0 },
  { "EXCCAUSE", 6, 0 },
  { "PSINTLEVEL", 4, 0 },
  { "PSUM", 1, 0 },
  { "PSWOE", 1, 0 },
  { "PSEXCM", 1, 0 },
  { "DEPC", 32, 0 },
  { "EXCVADDR", 32, 0 },
  { "WindowBase", 3, 0 },
  { "WindowStart", 8, 0 },
  { "PSCALLINC", 2, 0 },
  { "PSOWB", 4, 0 },
  { "LBEG", 32, 0 },
  { "LEND", 32, 0 },
  { "SAR", 6, 0 },
  { "THREADPTR", 32, 0 },
  { "LITBADDR", 20, 0 },
  { "LITBEN", 1, 0 },
  { "InOCDMode", 1, 0 },
  { "INTENABLE", 13, 0 },
  { "DBREAKA0", 32, 0 },
  { "DBREAKC0", 8, 0 },
  { "DBREAKA1", 32, 0 },
  { "DBREAKC1", 8, 0 },
  { "IBREAKA0", 32, 0 },
  { "IBREAKA1", 32, 0 },
  { "IBREAKENABLE", 2, 0 },
  { "ICOUNTLEVEL", 4, 0 },
  { "DEBUGCAUSE", 6, 0 },
  { "DBNUM", 4, 0 },
  { "CCOMPARE0", 32, 0 },
  { "CCOMPARE1", 32, 0 },
  { "CPENABLE", 4, 0 },
  { "SCOMPARE1", 32, 0 },
  { "ATOMCTL", 6, 0 },
  { "RoundMode", 2, 0 },
  { "InvalidEnable", 1, 0 },
  { "DivZeroEnable", 1, 0 },
  { "OverflowEnable", 1, 0 },
  { "UnderflowEnable", 1, 0 },
  { "InexactEnable", 1, 0 },
  { "InvalidFlag", 1, 0 },
  { "DivZeroFlag", 1, 0 },
  { "OverflowFlag", 1, 0 },
  { "UnderflowFlag", 1, 0 },
  { "InexactFlag", 1, 0 },
  { "FPreserved20", 20, 0 },
  { "FPreserved20a", 20, 0 },
  { "FPreserved5", 5, 0 },
  { "FPreserved7", 7, 0 },
  { "EXPSTATE", 32, XTENSA_STATE_IS_EXPORTED },
  { "SOV", 4, XTENSA_STATE_IS_SHARED_OR },
  { "SAT_MODE", 1, 0 },
  { "SAR0", 6, 0 },
  { "SAR1", 6, 0 },
  { "SAR2", 6, 0 },
  { "SAR3", 6, 0 },
  { "HSAR0", 6, 0 },
  { "HSAR1", 6, 0 },
  { "HSAR2", 6, 0 },
  { "HSAR3", 6, 0 },
  { "MAX_REG", 128, 0 },
  { "ARG_MAX_REG", 128, 0 },
  { "NCO_COUNTER", 128, 0 },
  { "INTERP_EXT_N", 4, 0 },
  { "INTERP_EXT_L", 4, 0 },
  { "LLR_BUF", 768, 0 },
  { "SMOD_BUF", 256, 0 },
  { "WEIGHT_REG", 8, 0 },
  { "SCALE_REG", 5, 0 },
  { "LLR_POS", 6, 0 },
  { "SMOD_POS", 7, 0 },
  { "PERM_REG", 32, 0 },
  { "SMOD_OFFSET_TABLE", 128, 0 },
  { "PHASOR_N", 4, 0 },
  { "PHASOR_OFFSET", 16, 0 }
};

#define NUM_STATES 100

enum xtensa_state_id {
  STATE_LCOUNT,
  STATE_PC,
  STATE_ICOUNT,
  STATE_DDR,
  STATE_INTERRUPT,
  STATE_CCOUNT,
  STATE_XTSYNC,
  STATE_VECBASE,
  STATE_EPC1,
  STATE_EPC2,
  STATE_EPC3,
  STATE_EPC4,
  STATE_EPC5,
  STATE_EPC6,
  STATE_EXCSAVE1,
  STATE_EXCSAVE2,
  STATE_EXCSAVE3,
  STATE_EXCSAVE4,
  STATE_EXCSAVE5,
  STATE_EXCSAVE6,
  STATE_EPS2,
  STATE_EPS3,
  STATE_EPS4,
  STATE_EPS5,
  STATE_EPS6,
  STATE_EXCCAUSE,
  STATE_PSINTLEVEL,
  STATE_PSUM,
  STATE_PSWOE,
  STATE_PSEXCM,
  STATE_DEPC,
  STATE_EXCVADDR,
  STATE_WindowBase,
  STATE_WindowStart,
  STATE_PSCALLINC,
  STATE_PSOWB,
  STATE_LBEG,
  STATE_LEND,
  STATE_SAR,
  STATE_THREADPTR,
  STATE_LITBADDR,
  STATE_LITBEN,
  STATE_InOCDMode,
  STATE_INTENABLE,
  STATE_DBREAKA0,
  STATE_DBREAKC0,
  STATE_DBREAKA1,
  STATE_DBREAKC1,
  STATE_IBREAKA0,
  STATE_IBREAKA1,
  STATE_IBREAKENABLE,
  STATE_ICOUNTLEVEL,
  STATE_DEBUGCAUSE,
  STATE_DBNUM,
  STATE_CCOMPARE0,
  STATE_CCOMPARE1,
  STATE_CPENABLE,
  STATE_SCOMPARE1,
  STATE_ATOMCTL,
  STATE_RoundMode,
  STATE_InvalidEnable,
  STATE_DivZeroEnable,
  STATE_OverflowEnable,
  STATE_UnderflowEnable,
  STATE_InexactEnable,
  STATE_InvalidFlag,
  STATE_DivZeroFlag,
  STATE_OverflowFlag,
  STATE_UnderflowFlag,
  STATE_InexactFlag,
  STATE_FPreserved20,
  STATE_FPreserved20a,
  STATE_FPreserved5,
  STATE_FPreserved7,
  STATE_EXPSTATE,
  STATE_SOV,
  STATE_SAT_MODE,
  STATE_SAR0,
  STATE_SAR1,
  STATE_SAR2,
  STATE_SAR3,
  STATE_HSAR0,
  STATE_HSAR1,
  STATE_HSAR2,
  STATE_HSAR3,
  STATE_MAX_REG,
  STATE_ARG_MAX_REG,
  STATE_NCO_COUNTER,
  STATE_INTERP_EXT_N,
  STATE_INTERP_EXT_L,
  STATE_LLR_BUF,
  STATE_SMOD_BUF,
  STATE_WEIGHT_REG,
  STATE_SCALE_REG,
  STATE_LLR_POS,
  STATE_SMOD_POS,
  STATE_PERM_REG,
  STATE_SMOD_OFFSET_TABLE,
  STATE_PHASOR_N,
  STATE_PHASOR_OFFSET
};


/* Field definitions.  */

static unsigned
Field_t_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_op2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_op1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_op1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_op0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_n_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_n_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_m_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_m_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_sr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_st_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_st_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_thi3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_thi3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2098inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2098inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_sae4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_sae4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2019_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2019_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld2100inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2100inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2102inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2102inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2186inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2186inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2185inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2185inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2149inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2149inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3627inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 19) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3627inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x1800) | (tie_t << 11);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2187inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2187inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2101inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2101inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2103inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2103inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2189inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2189inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2188inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2188inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2104inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2104inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2190inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2190inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2094inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 7) | ((insn[0] << 16) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2094inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe00) | (tie_t << 9);
  tie_t = (val << 21) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2105inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2105inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2191inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2191inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2192inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2192inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2194inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2194inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2197inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2197inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2160inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2160inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2173inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2173inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2112inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2112inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2199inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2199inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2200inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2200inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2114inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2114inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2113inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2113inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2201inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2201inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2115inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2115inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2215inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2215inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3630inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3630inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_dsp340050b49a6c_fld2203inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2203inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 22) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2254_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2254_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2116inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2116inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2117inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2117inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2119inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2119inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2048_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2048_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2089inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2089inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_r2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_bbi4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_bbi4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3631inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3631inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2085inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 11) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2085inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2088inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2088inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3633inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 14) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3633inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20000) | (tie_t << 17);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2082inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2082inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2083inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2083inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2084inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2084inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2086inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2086inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3634_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 14) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3634_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld2156inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2156inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2037_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2037_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld2021_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2021_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_sa4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  return tie_t;
}

static void
Field_sa4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2035_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2035_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld2225inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2225inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2226inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2226inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2228inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2228inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2230inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2230inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2222inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2222inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld2221inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2221inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2238inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2238inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2239inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2239inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2241inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2241inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2223inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2223inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld2232inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2232inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld2234inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2234inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld2237inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2237inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld2240inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2240inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld2229inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2229inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2224inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2224inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld2227inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2227inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld2231inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2231inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2247inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2247inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2091inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2091inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2153inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2153inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3635inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3635inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld2154inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2154inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3636inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3636inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld2155inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2155inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3637inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3637inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld2134inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2134inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2050_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 19) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2050_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e00) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld2096inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2096inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2244inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2244inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2245inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2245inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2246inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2246inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3638inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3638inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2235inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2235inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2157inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2157inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2253inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2253inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3639inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3639inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2255inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2255inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3640inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3640inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2171inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2171inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 22) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2172inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2172inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 22) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2174inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2174inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 22) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2158inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2158inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2205inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2205inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2159inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2159inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2161inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2161inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2168inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2168inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2136inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2136inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2090inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2090inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2184inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2184inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3642inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3642inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2252inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2252inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3643inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3643inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2092inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 7) | ((insn[0] << 16) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2092inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe00) | (tie_t << 9);
  tie_t = (val << 21) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2216inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2216inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3644inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3644inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2217inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2217inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_dsp340050b49a6c_fld3645inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3645inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2208inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2208inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2209inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2209inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2210inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2210inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2212inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2212inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2213inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2213inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3647inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3647inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2214inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2214inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3648inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3648inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2120inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2120inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
  tie_t = (val << 16) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2122inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2122inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
  tie_t = (val << 16) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2123inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2123inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
  tie_t = (val << 16) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2125inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2125inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
  tie_t = (val << 16) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2129inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 16) >> 27);
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2129inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
  tie_t = (val << 22) >> 27;
  insn[0] = (insn[0] & ~0xf800) | (tie_t << 11);
  tie_t = (val << 18) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2124inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2124inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
  tie_t = (val << 16) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2126inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2126inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
  tie_t = (val << 16) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2127inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2127inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
  tie_t = (val << 16) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2128inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2128inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
  tie_t = (val << 16) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2131inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 16) >> 27);
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2131inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
  tie_t = (val << 22) >> 27;
  insn[0] = (insn[0] & ~0xf800) | (tie_t << 11);
  tie_t = (val << 18) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2138inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2138inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2146inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2146inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3649inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3649inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld2147inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2147inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3650inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3650inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2139inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2139inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2140inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2140inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2142inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2142inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2248inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2248inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3651inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3651inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2250inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2250inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3653inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3653inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2257inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2257inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld3654inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3654inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2249inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2249inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3655inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3655inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2107inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2107inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
  tie_t = (val << 21) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2118inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2118inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
  tie_t = (val << 21) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2108inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2108inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
  tie_t = (val << 21) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2109inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2109inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
  tie_t = (val << 21) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2111inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2111inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
  tie_t = (val << 21) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2110inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2110inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
  tie_t = (val << 21) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2145inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 16) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2145inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf800) | (tie_t << 11);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2141inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2141inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2143inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2143inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2144inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 7) | ((insn[0] << 16) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2144inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe00) | (tie_t << 9);
  tie_t = (val << 21) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2204inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2204inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3656inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3656inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2195inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2195inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2196inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2196inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2198inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2198inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2169inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2169inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2220inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2220inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2106inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2106inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2151inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2151inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_dsp340050b49a6c_fld3657inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3657inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2251inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2251inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3658inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3658inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2206inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2206inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2202inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2202inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
  tie_t = (val << 22) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2095inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 7) | ((insn[0] << 16) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2095inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe00) | (tie_t << 9);
  tie_t = (val << 21) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2132inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2132inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
  tie_t = (val << 26) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
  tie_t = (val << 22) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3659inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3659inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2099inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 7) | ((insn[0] << 16) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2099inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe00) | (tie_t << 9);
  tie_t = (val << 21) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2137inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2137inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2133inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2133inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3660inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3660inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2175inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2175inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 19) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2177inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2177inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 19) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2242inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2242inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3661inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3661inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2162inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2162inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2164inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2164inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2163inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2163inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2218inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2218inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2219inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2219inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2207inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2207inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2211inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2211inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2165inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2165inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2166inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2166inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2178inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2178inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 19) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2180inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2180inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 19) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2179inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2179inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 19) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2181inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2181inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 19) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2167inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2167inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2193inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2193inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3662inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3662inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2236inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2236inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2243inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2243inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2182inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2182inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 19) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2183inst_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2183inst_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 19) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_op0_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_r_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_op0_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_z_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_z_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_i_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_i_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_s_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_sae_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  return tie_t;
}

static void
Field_sae_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_op0_s3_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s3_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_dsp340050b49a6c_fld2260gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2260gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2258gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2258gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2282gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2282gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2281gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2281gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2266gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 13) >> 18);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2266gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 17) >> 18;
  insn[0] = (insn[0] & ~0x7ffe0) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2302_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2302_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2312gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2312gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2386_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2386_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2283gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2283gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2286gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2286gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2287gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2287gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2289gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2289gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2293gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2293gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2288gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2288gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2290gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2290gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2359gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 11) | ((insn[0] << 19) >> 21);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2359gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x1ffc) | (tie_t << 2);
  tie_t = (val << 20) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2384_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2384_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2361gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 11) | ((insn[0] << 19) >> 21);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2361gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x1ffc) | (tie_t << 2);
  tie_t = (val << 20) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2362gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 10) | ((insn[0] << 19) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2362gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x1ff8) | (tie_t << 3);
  tie_t = (val << 21) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3663gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3663gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2364gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 19) >> 30);
  tie_t = (tie_t << 7) | ((insn[0] << 22) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2364gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f8) | (tie_t << 3);
  tie_t = (val << 23) >> 30;
  insn[0] = (insn[0] & ~0x1800) | (tie_t << 11);
  tie_t = (val << 22) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3664gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3664gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2366gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 7) | ((insn[0] << 22) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2366gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f8) | (tie_t << 3);
  tie_t = (val << 24) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3665gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3665gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2308gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2308gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2259gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2259gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 25) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2262gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 13) >> 19);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2262gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x7ffc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2284gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2284gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2275gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2275gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2354gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2354gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2333gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2333gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2310gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2310gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3667gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3667gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2357gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2357gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2376gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2376gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2313_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2313_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld2343gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2343gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2342gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2342gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2344gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2344gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2345gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2345gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2346gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2346gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2373gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2373gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2374gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2374gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2375gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2375gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2335gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2335gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2339gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2339gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2334gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2334gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2336gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2336gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2337gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2337gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2338gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2338gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2340gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2340gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2341gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2341gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2369gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2369gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3668gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3668gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2280gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2280gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2309gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2309gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2261gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 13) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2261gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x7ff80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2321gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2321gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2322gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2322gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2355gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2355gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2324gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2324gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2372gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2372gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3669gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3669gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2263gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 13) >> 15);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2263gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x7fffc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2044_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 25) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2044_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2264gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 13) >> 18);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2264gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 17) >> 18;
  insn[0] = (insn[0] & ~0x7ffe0) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2368gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2368gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3670gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3670gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2291gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2291gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2292gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2292gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2294gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2294gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2295gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2295gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2297gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2297gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2296gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2296gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2301gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2301gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2272_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2272_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2277gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2277gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2279gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2279gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2278gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2278gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2267gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2267gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2268gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2268gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2269gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2269gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2271gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2271gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 21) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2305_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2305_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_dsp340050b49a6c_fld2270gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2270gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2273gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2273gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 21) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2298gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2298gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2299gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2299gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2300gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2300gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2303gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2303gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3671gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3671gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2379gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2379gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3673gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3673gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld2274gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 13) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2274gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2056_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2056_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2306gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2306gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2304gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2304gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3674gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3674gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2353gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2353gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2371gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2371gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3675gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3675gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2314gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2314gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2316gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2316gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2317gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2317gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2319gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2319gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2378gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2378gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3676gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3676gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld2323gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2323gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2331gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2331gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2347gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2347gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2383gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2383gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3678gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3678gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld2318gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2318gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2332gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2332gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2348gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2348gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2349gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2349gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2351gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2351gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2370gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2370gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2032_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2032_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2320gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2320gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2350gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2350gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2352gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2352gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2325gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2325gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2327gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2327gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2326gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2326gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2328gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2328gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2356gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2356gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2329gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2329gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2381gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2381gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3666_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3666_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2330gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2330gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2385gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2385gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2387gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2387gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2388gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2388gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3679gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3679gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld2358gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2358gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2389gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2389gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3680gp_slot2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3680gp_slot2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld2399gp_slot1_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2399gp_slot1_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_op0_s4_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 15) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s4_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x1c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3681gp_slot1_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3681gp_slot1_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 23) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2395gp_slot1_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2395gp_slot1_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2394gp_slot1_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2394gp_slot1_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2397gp_slot1_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2397gp_slot1_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2400gp_slot1_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2400gp_slot1_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3683gp_slot1_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3683gp_slot1_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld2402gp_slot1_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2402gp_slot1_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2403gp_slot1_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2403gp_slot1_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3684gp_slot1_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3684gp_slot1_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld2405gp_slot1_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2405gp_slot1_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3686gp_slot1_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3686gp_slot1_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld2398gp_slot1_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2398gp_slot1_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_sae_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  return tie_t;
}

static void
Field_sae_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_op0_s5_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s5_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_dsp340050b49a6c_fld2447gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2447gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3688gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3688gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2449gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 13) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2449gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x60000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3689gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 15) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3689gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2418gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2418gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2462_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2462_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2464gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2464gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2454gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2454gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2436gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2436gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 21) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3690gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3690gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2438gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 13) >> 19);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2438gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x7ffc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2437gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 13) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2437gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x7ff80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2526gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2526gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2460gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2460gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2459gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2459gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2445_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2445_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2427gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2427gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 21) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2420gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2420gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2424gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2424gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2425gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2425gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2480gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2480gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2479gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2479gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2419gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2419gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 22) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2481gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2481gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2483gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2483gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2487gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2487gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2482gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2482gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2426gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2426gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2484gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2484gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2422gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2422gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2429gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2429gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2485gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2485gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2486gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2486gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2488gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2488gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2531gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2531gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3691gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 23) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3691gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e0) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2493gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2493gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2506gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2506gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3692gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3692gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2494gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2494gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2407gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2407gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2413gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2413gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2415gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2415gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2417gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2417gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2441gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2441gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3693gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3693gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2409gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2409gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2410gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2410gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2416gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2416gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2411gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2411gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2412gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2412gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2453gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2453gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2451gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2451gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2452gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2452gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2516gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2516gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2512gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2512gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2514gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2514gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2515gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2515gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2443gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 13) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2443gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2444gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2444gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2067_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2067_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2439gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 13) >> 20);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2439gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 19) >> 20;
  insn[0] = (insn[0] & ~0x7ff80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld3695gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3695gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2423gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2423gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2508gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2508gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2058_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2058_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2509gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2509gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2510gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2510gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3696gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3696gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2496gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2496gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_s8_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2527gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2527gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2036_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2036_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2528gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2528gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3697gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3697gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2523gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2523gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3698gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3698gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld2455gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2455gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2456gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2456gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2458gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2458gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2457gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2457gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2440gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 13) >> 20);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2440gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 19) >> 20;
  insn[0] = (insn[0] & ~0x7ff80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2524gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2524gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 25) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3699gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3699gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld2503gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2503gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2507gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 13) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2507gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x60000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3700gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3700gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2498gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2498gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2500gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2500gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2501gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2501gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2502gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2502gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2504gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2504gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2505gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2505gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2433gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2433gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2430gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2430gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2431gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2431gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2432gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2432gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2434gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2434gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2435gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2435gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2517gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2517gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2518gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2518gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2519gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2519gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2520gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2520gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2489gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2489gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2491gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2491gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2490gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2490gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2492gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2492gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2529gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2529gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3702gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3702gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2468gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2468gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2470gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2470gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2448_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2448_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3703gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3703gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2521gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2521gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2530_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2530_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld2461gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2461gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2463gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2463gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2497gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2497gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2499gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2499gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2465gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2465gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2467gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2467gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2471gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2471gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2473gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2473gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2477gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2477gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 21) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3705gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3705gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2472gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2472gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2495gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2495gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3706gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3706gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2466gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2466gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2474gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2474gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2475gp_slot0_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2475gp_slot0_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 19) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2595dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 12) >> 25);
  tie_t = (tie_t << 9) | ((insn[0] << 21) >> 23);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2595dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x7fc) | (tie_t << 2);
  tie_t = (val << 16) >> 25;
  insn[0] = (insn[0] & ~0xfe000) | (tie_t << 13);
}

static unsigned
Field_op0_s6_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s6_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_dsp340050b49a6c_fld3708dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 19) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3708dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x1800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2579dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2579dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2580dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2580dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2582dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2582dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2586dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2586dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2581dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2581dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2583dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2583dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2599dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 10) | ((insn[0] << 20) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2599dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc) | (tie_t << 2);
  tie_t = (val << 20) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3709dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3709dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2614_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2614_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2604dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2604dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 23) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3710dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3710dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2606dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2606dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 24) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3711dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3711dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2601dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 10) | ((insn[0] << 20) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2601dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc) | (tie_t << 2);
  tie_t = (val << 20) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2602dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2602dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
  tie_t = (val << 21) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3713dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3713dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2645dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2645dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3714dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3714dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2658dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2658dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3716dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3716dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3717dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3717dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
  tie_t = (val << 26) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld2636dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 12) >> 18);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2636dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0xfffc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2577dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2577dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2635dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2635dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3719dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3719dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2571dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2571dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2547dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2547dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2646dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2646dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_dsp340050b49a6c_fld3721dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3721dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2574dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2574dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2655dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2655dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2029_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2029_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2557dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2557dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2558dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2558dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2560dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2560dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2559dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2559dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2561dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2561dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2562dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2562dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2563dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2563dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2647dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2647dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2549dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2549dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2550dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2550dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2552dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2552dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2556dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2556dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2551dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2551dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2553dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2553dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2554dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2554dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2555dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2555dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2573dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2573dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2628dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2628dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_dsp340050b49a6c_fld3722_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3722_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2642dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 12) >> 23);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2642dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 22) >> 23;
  insn[0] = (insn[0] & ~0xff800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2605_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2605_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2539dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2539dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2578_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2578_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2541dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2541dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2572dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2572dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2542dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2542dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3723dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 18) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3723dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff0) | (tie_t << 4);
}

static unsigned
Field_dsp340050b49a6c_fld2591dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 12) >> 14);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2591dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2596dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2596dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 19) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3724dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3724dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2592dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 12) >> 25);
  tie_t = (tie_t << 9) | ((insn[0] << 21) >> 23);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2592dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x7fc) | (tie_t << 2);
  tie_t = (val << 16) >> 25;
  insn[0] = (insn[0] & ~0xfe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2598dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2598dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2584dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2584dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2585dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2585dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2587dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2587dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2588dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2588dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2590dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2590dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2589dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2589dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2608dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2608dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2609dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2609dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2610dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2610dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2626dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2626dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 25) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3715_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3715_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2613dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2613dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 19) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2616dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2616dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 19) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2621dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2621dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 19) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2615dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2615dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 19) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2617dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2617dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 19) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2618dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2618dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 19) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2637dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2637dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 19) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3725dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3725dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2641dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 12) >> 21);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2641dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0xffe00) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld3726dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3726dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2619dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2619dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 18) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2620dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2620dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 18) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2622dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2622dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 19) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2623dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 12) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2623dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0xff800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3727dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3727dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2654dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 5) | ((insn[0] << 21) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2654dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c0) | (tie_t << 6);
  tie_t = (val << 25) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3728dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3728dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2611dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 12) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2611dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0xff800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2612_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 12) >> 23);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2612_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2624dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2624dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 21) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3729dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3729dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2625_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2625_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3731dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3731dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2643dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 12) >> 23);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2643dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 22) >> 23;
  insn[0] = (insn[0] & ~0xff800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2640dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2640dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 19) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld2569dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2569dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2632dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2632dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_t_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_t_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2532dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2532dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2644dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2644dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3732dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3732dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2533dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2533dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2534dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2534dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2536dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2536dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2652dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 5) | ((insn[0] << 21) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2652dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c0) | (tie_t << 6);
  tie_t = (val << 25) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3718_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3718_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2540dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2540dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2548dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2548dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2564dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2564dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2657dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2657dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2535dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2535dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2537dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2537dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2565dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2565dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2566dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2566dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2568dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2568dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2630dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2630dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2032_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2032_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2538dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2538dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2633dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2633dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3733dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3733dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2567dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2567dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2544dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2544dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2543dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2543dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2545dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2545dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2546dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2546dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2575dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2575dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2648dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2648dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2649dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2649dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2651dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2651dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2656dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2656dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3712_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3712_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2576dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2576dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2650dot_slot2_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2650dot_slot2_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_op0_s7_Slot_dot_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s7_Slot_dot_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3734dot_slot1_Slot_dot_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 15) >> 17);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3734dot_slot1_Slot_dot_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x1fffc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2068_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2068_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_op0_s8_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s8_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2668dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2668dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2666dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2666dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2674dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2674dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2688dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2688dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 25) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3735dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 19) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3735dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x1800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2705dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2705dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3737dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3737dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2677dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2677dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2678dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2678dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2679dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2679dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2690dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2690dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2680dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2680dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_t_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_t_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2697dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2697dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3738dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3738dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2667dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2667dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2704dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 17) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2704dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x7800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3739dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 21) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3739dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x7e0) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2689dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2689dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_r_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_r_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2669dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2669dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2671dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2671dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2675dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2675dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2672dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2672dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2673dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2673dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2676dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2676dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2682dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2682dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2686dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2686dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 25) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3736_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 19) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3736_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x1800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2681dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2681dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2683dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2683dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2684dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2684dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2685dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2685dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2699dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2699dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3740dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3740dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2692dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2692dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2693dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2693dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 24) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2695dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2695dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3741dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3741dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3742dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3742dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2700dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2700dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2702dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2702dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2701dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2701dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2703dot_slot0_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2703dot_slot0_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_sae_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  return tie_t;
}

static void
Field_sae_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_op0_s9_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s9_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_dsp340050b49a6c_fld2707pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2707pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2817_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2817_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2739pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2739pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3744pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3744pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2717pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2717pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2713pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 13) >> 18);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2713pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 17) >> 18;
  insn[0] = (insn[0] & ~0x7ffe0) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld3745pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3745pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
}

static unsigned
Field_t_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_t_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2718pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2718pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2721pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2721pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2722pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2722pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2724pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2724pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2728pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2728pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2736pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2736pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 22) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2819_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2819_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2723pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2723pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2793pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 11) | ((insn[0] << 19) >> 21);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2793pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x1ffc) | (tie_t << 2);
  tie_t = (val << 20) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2795pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 11) | ((insn[0] << 19) >> 21);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2795pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x1ffc) | (tie_t << 2);
  tie_t = (val << 20) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2796pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 10) | ((insn[0] << 19) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2796pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x1ff8) | (tie_t << 3);
  tie_t = (val << 21) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3746pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3746pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2798pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 19) >> 30);
  tie_t = (tie_t << 7) | ((insn[0] << 22) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2798pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f8) | (tie_t << 3);
  tie_t = (val << 23) >> 30;
  insn[0] = (insn[0] & ~0x1800) | (tie_t << 11);
  tie_t = (val << 22) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3747pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3747pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2801pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 7) | ((insn[0] << 22) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2801pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f8) | (tie_t << 3);
  tie_t = (val << 24) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3749pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3749pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2743pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2743pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3750pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3750pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2706pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 13) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2706pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2709pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 13) >> 19);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2709pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x7ffc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2719pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2719pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2715pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2715pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2788pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2788pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2747pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2747pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2791pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2791pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2775pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2775pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2777pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2777pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2776pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2776pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2778pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2778pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2779pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2779pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2780pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2780pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2810pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2810pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2811pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2811pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2767pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2767pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2769pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2769pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2773pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2773pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2768pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2768pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2770pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2770pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2771pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2771pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2772pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2772pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2774pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2774pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2805pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2805pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3751pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3751pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2741pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2741pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2746pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2746pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3752pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3752pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2755pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2755pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2756pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2756pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2789pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2789pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2758pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2758pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2809pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2809pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3753pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3753pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2710pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 13) >> 15);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2710pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x7fffc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2711pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 13) >> 18);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2711pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 17) >> 18;
  insn[0] = (insn[0] & ~0x7ffe0) | (tie_t << 5);
}

static unsigned
Field_s_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2803pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2803pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3754pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3754pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2725pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2725pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2726pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2726pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2727pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2727pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2729pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2729pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2730pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2730pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2732pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2732pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2731pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2731pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2733pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2733pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2734pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2734pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2735pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2735pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2807pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2807pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3756pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3756pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2742pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2742pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2738pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2738pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 22) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2708pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 13) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2708pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x7ff80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2714pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 13) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2714pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x7fe00) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld2787pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2787pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2808pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2808pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3757pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3757pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2748pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2748pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2750pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2750pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2751pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2751pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2753pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2753pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2816pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2816pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_imm7_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_imm7_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2757pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2757pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2765pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2765pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2781pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2781pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2814pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2814pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3758pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3758pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld2752pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2752pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2766pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2766pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2782pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2782pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2783pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2783pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2785pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2785pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2806pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2806pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2025_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2025_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2754pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2754pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2784pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2784pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2786pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2786pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2759pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2759pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2761pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2761pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2760pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2760pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2762pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2762pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2790pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2790pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2763pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2763pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2812pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2812pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3748_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3748_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2764pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2764pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2818pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2818pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2737_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2737_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld2820pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2820pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2821pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2821pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3759pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3759pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld2792pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2792pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2823pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2823pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3760pq_slot2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3760pq_slot2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld2826pq_slot1_Slot_pq_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2826pq_slot1_Slot_pq_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_op0_s10_Slot_pq_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s10_Slot_pq_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_dsp340050b49a6c_fld3761pq_slot1_Slot_pq_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 7) | ((insn[0] << 23) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3761pq_slot1_Slot_pq_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc) | (tie_t << 2);
  tie_t = (val << 21) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2825pq_slot1_Slot_pq_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2825pq_slot1_Slot_pq_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_sae_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  return tie_t;
}

static void
Field_sae_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_op0_s11_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s11_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_dsp340050b49a6c_fld2867pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2867pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3763pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3763pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2869pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 13) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2869pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x60000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3764pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 15) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3764pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2838pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2838pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2882_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2882_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2884pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2884pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2874pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2874pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2856pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2856pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 21) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3765pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3765pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2858pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 13) >> 19);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2858pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x7ffc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2857pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 13) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2857pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x7ff80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2946pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2946pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2880pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2880pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2879pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2879pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2865_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2865_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2847pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2847pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 21) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2840pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2840pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2844pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2844pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2845pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2845pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2900pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2900pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2899pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2899pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2839pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2839pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 22) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2901pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2901pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2903pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2903pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2907pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2907pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2902pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2902pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2846pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2846pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2904pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2904pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2842pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2842pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2849pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2849pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2905pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2905pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2906pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2906pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2908pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2908pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2950pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2950pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3766pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 23) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3766pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e0) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2913pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2913pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2926pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2926pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3767pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3767pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2914pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2914pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2827pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2827pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2833pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2833pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2835pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2835pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2837pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2837pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2861pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2861pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3768pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3768pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2829pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2829pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2830pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2830pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2836pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2836pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2831pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2831pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2832pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2832pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2873pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2873pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2871pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2871pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2872pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2872pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2936pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2936pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2932pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2932pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2934pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2934pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2935pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2935pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2863pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 13) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2863pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2864pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2864pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2069_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2069_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2859pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 13) >> 20);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2859pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 19) >> 20;
  insn[0] = (insn[0] & ~0x7ff80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2940_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2940_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2843pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2843pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2928pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2928pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2059_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2059_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2929pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2929pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2930pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2930pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3769pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3769pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2916pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2916pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_s8_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2947pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2947pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2036_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2036_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2948pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2948pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3770pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3770pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2942pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2942pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 25) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2875pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2875pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2876pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2876pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2878pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2878pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2877pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2877pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2860pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 13) >> 20);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2860pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 19) >> 20;
  insn[0] = (insn[0] & ~0x7ff80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2941pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2941pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3771pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3771pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2923pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2923pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2927pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 13) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2927pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x60000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3773pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3773pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2918pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2918pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2920pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2920pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2921pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2921pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2922pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2922pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2924pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2924pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2925pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2925pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2853pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2853pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2850pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2850pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2851pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2851pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2852pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2852pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2854pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2854pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2855pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2855pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2943pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2943pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 25) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3775pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3775pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3776pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3776pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3777pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3777pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2945pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2945pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 25) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2909pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2909pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2911pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2911pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2910pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2910pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2912pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2912pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2949pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2949pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3778pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3778pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2888pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2888pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2890pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2890pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2937pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2937pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2939pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2939pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3772_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3772_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2881pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2881pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2883pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2883pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2917pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2917pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2919pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2919pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2885pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2885pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2887pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2887pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2891pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2891pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2893pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2893pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2897pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2897pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 21) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3779pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3779pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2892pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2892pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2915pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2915pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3780pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3780pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2886pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2886pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2894pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2894pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2895pq_slot0_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2895pq_slot0_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 19) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2953acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2953acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_op0_s12_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s12_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3782acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3782acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2956acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2956acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_s_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2967acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2967acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2056_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2056_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2966acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2966acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_dsp340050b49a6c_fld3783acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3783acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2957acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2957acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2958acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2958acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2960acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2960acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 25) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3784acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3784acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2964acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2964acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3785acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3785acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2959acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2959acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2963acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2963acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 25) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2954acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2954acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3786acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3786acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2955acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2955acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld3788acc2_slot2_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3788acc2_slot2_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2969acc2_slot1_Slot_acc2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2969acc2_slot1_Slot_acc2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_op0_s13_Slot_acc2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s13_Slot_acc2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_dsp340050b49a6c_fld3790acc2_slot1_Slot_acc2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 8) >> 18);
  tie_t = (tie_t << 7) | ((insn[0] << 23) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3790acc2_slot1_Slot_acc2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc) | (tie_t << 2);
  tie_t = (val << 11) >> 18;
  insn[0] = (insn[0] & ~0xfffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2968acc2_slot1_Slot_acc2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2968acc2_slot1_Slot_acc2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3793acc2_slot1_Slot_acc2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 11) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 6) | ((insn[0] << 24) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3793acc2_slot1_Slot_acc2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc) | (tie_t << 2);
  tie_t = (val << 22) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 18) >> 28;
  insn[0] = (insn[0] & ~0x1e0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld2075_Slot_acc2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2075_Slot_acc2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2031_Slot_acc2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 11) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2031_Slot_acc2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e0000) | (tie_t << 17);
}

static unsigned
Field_op0_s14_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s14_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_r_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_r_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2973acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2973acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3795acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3795acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2980acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 18) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2980acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x3e00) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld3796acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3796acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2976acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 18) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2976acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc0) | (tie_t << 6);
}

static unsigned
Field_t_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_t_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2989acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2989acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3798acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3798acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2056_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2056_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2990acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2990acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld3799acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3799acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2977acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 18) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2977acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x3e00) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld3797_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3797_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2981acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2981acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3800acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3800acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2975acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 18) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2975acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2982acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2982acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3801acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3801acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2984acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2984acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2985acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2985acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3802acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3802acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2987acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2987acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3803acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3803acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2039_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 25) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2039_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2974acc2_slot0_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 18) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2974acc2_slot0_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f00) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3043smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 15) | ((insn[0] << 15) >> 17);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3043smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x1fffc) | (tie_t << 2);
  tie_t = (val << 16) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_op0_s15_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s15_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_dsp340050b49a6c_fld3805smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 13) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3805smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3061smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3061smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 23) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3806smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3806smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3063smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3063smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 24) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3807smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3807smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3049smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3049smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3050smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3050smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3052smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3052smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3056smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3056smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
  tie_t = (val << 19) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_dsp340050b49a6c_fld3809smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3809smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3038smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 16) >> 18);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3038smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0xfffc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3091smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 12) >> 23);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3091smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2041_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2041_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3102smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3102smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3810smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3810smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3116smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3116smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3812smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3812smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3813smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3813smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
  tie_t = (val << 26) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3092smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 12) >> 18);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3092smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0xfffc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3047smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3047smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3090smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3090smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3814smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3814smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3030smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3030smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3006smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3006smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3104smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3104smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_dsp340050b49a6c_fld3816smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3816smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3033smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3033smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3111smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 21) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3111smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x780) | (tie_t << 7);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2056_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2056_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3016smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3016smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3017smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3017smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3019smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3019smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3018smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3018smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3020smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3020smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3021smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3021smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3022smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3022smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3105smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3105smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3008smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3008smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3009smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3009smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3011smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3011smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3015smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3015smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3010smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3010smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3012smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3012smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3013smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3013smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3014smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3014smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3070_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3070_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3032smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3032smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3084smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3084smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_dsp340050b49a6c_fld3817_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3817_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3098smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 12) >> 23);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3098smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 22) >> 23;
  insn[0] = (insn[0] & ~0xff800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3062_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3062_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2998smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2998smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3048_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3048_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3000smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3000smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3031smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3031smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3001smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3001smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3818smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 18) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3818smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff0) | (tie_t << 4);
}

static unsigned
Field_dsp340050b49a6c_fld3039smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 12) >> 14);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3039smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3044smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 9) | ((insn[0] << 21) >> 23);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3044smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x7fc) | (tie_t << 2);
  tie_t = (val << 19) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3819smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3819smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3040smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 15) | ((insn[0] << 15) >> 17);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3040smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x1fffc) | (tie_t << 2);
  tie_t = (val << 16) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_dsp340050b49a6c_fld3046smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3046smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3051smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3051smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3053smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3053smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3054smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3054smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3055smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3055smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3058smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3058smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
  tie_t = (val << 19) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_dsp340050b49a6c_fld3059smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 14) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3059smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 21) >> 31;
  insn[0] = (insn[0] & ~0x20000) | (tie_t << 17);
  tie_t = (val << 20) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_dsp340050b49a6c_fld3821smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3821smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3065smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3065smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3066smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3066smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3067smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3067smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3080smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3080smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3069smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3069smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 19) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3071smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3071smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 19) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3072smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3072smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 19) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3074smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3074smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 19) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3073smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3073smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 19) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3075smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3075smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 19) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3093smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3093smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 19) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3822smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3822smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld3097smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 12) >> 21);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3097smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0xffe00) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld3823smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3823smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3076smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3076smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 18) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3077smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3077smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 18) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3078smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3078smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 18) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3079smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3079smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 18) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3036smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 9) | ((insn[0] << 21) >> 23);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3036smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x7fc) | (tie_t << 2);
  tie_t = (val << 21) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3068smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3068smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3081smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3081smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3082smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3082smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3824smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3824smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3100smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3100smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3825smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3825smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3106smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3106smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3099smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 12) >> 23);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3099smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 22) >> 23;
  insn[0] = (insn[0] & ~0xff800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3096smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3096smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 19) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3028smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3028smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3087smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3087smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_t_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_t_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2991smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2991smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3101smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3101smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3826smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3826smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2992smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2992smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2993smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2993smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2995smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2995smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3113smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 21) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3113smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x780) | (tie_t << 7);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3827smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3827smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2999smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2999smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3007smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3007smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3023smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3023smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3115smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3115smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2029_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2029_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2994smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2994smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2996smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2996smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3024smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3024smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3025smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3025smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3027smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3027smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3085smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3085smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2032_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2032_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2997smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2997smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3088smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3088smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3828smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3828smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld3026smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3026smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3003smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3003smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3002smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3002smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3004smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3004smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3005smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3005smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3034smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3034smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3107smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3107smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3109smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3109smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3114smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3114smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3808_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3808_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3108smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3108smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3035smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3035smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3110smod_slot2_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3110smod_slot2_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3118smod_slot1_Slot_smod_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3118smod_slot1_Slot_smod_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_op0_s16_Slot_smod_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s16_Slot_smod_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_dsp340050b49a6c_fld3829smod_slot1_Slot_smod_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 16) >> 26);
  tie_t = (tie_t << 7) | ((insn[0] << 23) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3829smod_slot1_Slot_smod_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc) | (tie_t << 2);
  tie_t = (val << 19) >> 26;
  insn[0] = (insn[0] & ~0xfc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3117smod_slot1_Slot_smod_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3117smod_slot1_Slot_smod_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2080_Slot_smod_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2080_Slot_smod_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_sae_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  return tie_t;
}

static void
Field_sae_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_op0_s17_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s17_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_dsp340050b49a6c_fld3120smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 13) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3120smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3122smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3122smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3121smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3121smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3131smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3131smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3126smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3126smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3148smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 13) >> 25);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3148smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 21) >> 25;
  insn[0] = (insn[0] & ~0x7f000) | (tie_t << 12);
}

static unsigned
Field_imm6_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 20) >> 26);
  return tie_t;
}

static void
Field_imm6_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3164smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 13) >> 21);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3164smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 20) >> 21;
  insn[0] = (insn[0] & ~0x7ff00) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3832smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3832smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld3160smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 13) >> 19);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3160smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x7ffc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3161smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 13) >> 21);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3161smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 20) >> 21;
  insn[0] = (insn[0] & ~0x7ff00) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3159smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 13) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3159smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x7ff80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld3165smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3165smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3135smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3135smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3133smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3133smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3119smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3119smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3155smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3155smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3833smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3833smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3149smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3149smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3834_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3834_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3137smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3137smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3138smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3138smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3184smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3184smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3836smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 24) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3836smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3182smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3182smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_sas_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 25) >> 27);
  return tie_t;
}

static void
Field_sas_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3153smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3153smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3186smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3186smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3837smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 23) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3837smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3168smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3168smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3171smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3171smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3175smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3175smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3140smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3140smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3170smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3170smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3152smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3152smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3144smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3144smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3172smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3172smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3173smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3173smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3174smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3174smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3188smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3188smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3838smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3838smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
  tie_t = (val << 25) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3180smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3180smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3166smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 7) | ((insn[0] << 22) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3166smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f8) | (tie_t << 3);
  tie_t = (val << 20) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3181smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 7) | ((insn[0] << 22) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3181smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f8) | (tie_t << 3);
  tie_t = (val << 20) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_s8_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3136smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3136smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3123smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3123smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3134smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3134smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3125smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3125smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3127smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3127smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3128smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3128smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3130smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3130smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3129smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3129smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3132smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3132smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3139smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3139smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3141smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3141smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3142smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3142smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3143smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3143smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3145smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3145smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3146smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 13) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3146smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x7f800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3150_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3150_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3156smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3156smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3157smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3157smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3158smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3158smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3176smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3176smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3177smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3177smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3179smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3179smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3178smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3178smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 19) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3841smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3841smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3842smod_slot0_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3842smod_slot0_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3208llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3208llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
  tie_t = (val << 18) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_op0_s18_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s18_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3843llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3843llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3193llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3193llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3194llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3194llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3196llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3196llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3200llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3200llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3213llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 14) >> 31);
  tie_t = (tie_t << 7) | ((insn[0] << 22) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3213llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f8) | (tie_t << 3);
  tie_t = (val << 24) >> 31;
  insn[0] = (insn[0] & ~0x20000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3845llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 15) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3845llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x1c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3195llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3195llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3206_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 20) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3206_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3225_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3225_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3205_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3205_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3847llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3847llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3212_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 22) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3212_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f8) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld3848llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3848llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3216llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3216llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 26) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld3849llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3849llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3215llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3215llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3850llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3850llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3234llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3234llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3232llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3232llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3237llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 14) >> 25);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3237llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 21) >> 25;
  insn[0] = (insn[0] & ~0x3f800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2074_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2074_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3192llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3192llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3230_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3230_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_dsp340050b49a6c_fld3191llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3191llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3243llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 14) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3243llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc00) | (tie_t << 10);
}

static unsigned
Field_t_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_t_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3218llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3218llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld3851llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3851llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3244llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3244llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3853llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3853llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3242llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3242llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3855llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3855llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
  tie_t = (val << 26) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3231llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3231llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3856llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 18) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3856llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e00) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld3203llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 14) >> 16);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3203llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0x3fffc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3204llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  tie_t = (tie_t << 10) | ((insn[0] << 20) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3204llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc) | (tie_t << 2);
  tie_t = (val << 17) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3844_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3844_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3207llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  tie_t = (tie_t << 10) | ((insn[0] << 20) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3207llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc) | (tie_t << 2);
  tie_t = (val << 17) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3197llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3197llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3198llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3198llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3199llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3199llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3201llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3201llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3202llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3202llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3210llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  tie_t = (tie_t << 7) | ((insn[0] << 22) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3210llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f8) | (tie_t << 3);
  tie_t = (val << 22) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3857llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3857llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3217_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3217_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld3859llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 14) >> 24);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3859llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 23) >> 24;
  insn[0] = (insn[0] & ~0x3fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3221llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3221llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3222llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3222llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3860llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3860llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3224llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3224llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3861llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3861llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3220llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3220llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3246_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3246_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3214_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 14) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3214_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3863llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 15) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3863llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x1f800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3226llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3226llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3864llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3864llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3235llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 14) >> 25);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3235llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 21) >> 25;
  insn[0] = (insn[0] & ~0x3f800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3238llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 14) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3238llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x3f000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3862_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3862_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3241llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3241llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3865llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3865llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3236_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 14) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3236_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3240llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3240llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3228llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3228llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3866llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3866llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_dsp340050b49a6c_fld3247llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3247llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3867llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3867llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_s_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3233_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3233_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld2029_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2029_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3245llr_slot2_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3245llr_slot2_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3868_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3868_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3250llr_slot1_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3250llr_slot1_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_op0_s19_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s19_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_dsp340050b49a6c_fld3869llr_slot1_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 19) >> 30);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3869llr_slot1_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 22) >> 30;
  insn[0] = (insn[0] & ~0x1800) | (tie_t << 11);
  tie_t = (val << 18) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3254llr_slot1_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3254llr_slot1_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3872llr_slot1_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3872llr_slot1_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 25) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
  tie_t = (val << 21) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3252llr_slot1_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3252llr_slot1_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3875llr_slot1_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3875llr_slot1_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3253llr_slot1_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3253llr_slot1_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3876llr_slot1_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 18) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3876llr_slot1_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e00) | (tie_t << 9);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3251llr_slot1_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3251llr_slot1_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3878llr_slot1_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3878llr_slot1_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3248llr_slot1_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3248llr_slot1_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3870_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 19) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3870_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x1800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2071_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2071_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_op0_s20_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s20_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3260llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3260llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3258llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3258llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3266llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3266llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3286llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 25) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3286llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c) | (tie_t << 2);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3879llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3879llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3303llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3303llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3269llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3269llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3293llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3293llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3297llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3297llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3881llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3881llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3272llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3272llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3274llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3274llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3302llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3302llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3883llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3883llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3275llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3275llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3289llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3289llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3292llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3292llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3277llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3277llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3276llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3276llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3270llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 25) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3270llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c) | (tie_t << 2);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3312llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3312llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3885llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3885llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3304llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3304llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
  tie_t = (val << 24) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3887llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3887llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3283llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3283llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3310llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3310llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3888llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3888llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3288llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 25) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3288llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78) | (tie_t << 3);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2056_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2056_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld3284llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 5) | ((insn[0] << 25) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3284llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c) | (tie_t << 2);
  tie_t = (val << 25) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 24) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2041_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2041_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld3305llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3305llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
  tie_t = (val << 24) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3306llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 19) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3306llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x1800) | (tie_t << 11);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3890llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3890llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3259llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3259llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3291llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3291llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3261llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3261llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3263llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3263llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3267llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3267llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3264llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3264llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3265llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3265llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3268llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3268llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3308llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3308llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3892llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3892llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3294llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3294llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3295llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3295llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3296llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3296llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3298llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3298llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3299llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3299llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3300llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 17) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3300llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x7800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3893llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3893llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3278llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3278llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3279llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3279llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3280llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3280llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3282llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3282llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3281llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 5) | ((insn[0] << 25) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3281llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c) | (tie_t << 2);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3311llr_slot0_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3311llr_slot0_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_r_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_r_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3364_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3364_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_op0_s21_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s21_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_dsp340050b49a6c_fld3464dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3464dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3894dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 10) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3894dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3465dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3465dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3895dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 10) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3895dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 25) >> 26;
  insn[0] = (insn[0] & ~0x3f0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3459dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3459dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld3896dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 11) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3896dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3468dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 9) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3468dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x400000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3897dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3897dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_dsp340050b49a6c_fld3467dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 9) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3467dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x400000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3899dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3899dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_dsp340050b49a6c_fld3414dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3414dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3313dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3313dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3316dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3316dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3334dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3334dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_t_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_t_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3314_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3314_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3418dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3418dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3425dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3425dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3408dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 9) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3408dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x400000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3901dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3901dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_dsp340050b49a6c_fld3315dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3315dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3421dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3421dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3443dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3443dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3420dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3420dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3423dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3423dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3422dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3422dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3424dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3424dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3416dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3416dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3461dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3461dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3415dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3415dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3426dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3426dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3417dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3417dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3419dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3419dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3318_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3318_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3904dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3904dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3482dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3482dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld3903dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3903dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_dsp340050b49a6c_fld2044_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 8) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2044_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80000) | (tie_t << 19);
}

static unsigned
Field_dsp340050b49a6c_fld3407_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3407_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_dsp340050b49a6c_fld3905dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 9) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3905dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3479dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3479dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 23) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3906dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3906dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3475dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3475dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 20) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3898dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3898dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3353dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 8) >> 25);
  tie_t = (tie_t << 13) | ((insn[0] << 17) >> 19);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3353dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x7ffc) | (tie_t << 2);
  tie_t = (val << 12) >> 25;
  insn[0] = (insn[0] & ~0xfe0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3907dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3907dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3388dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 8) >> 19);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3388dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 15) >> 19;
  insn[0] = (insn[0] & ~0xfff800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3913dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3913dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3387dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3387dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3396dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 8) >> 25);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3396dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 21) >> 25;
  insn[0] = (insn[0] & ~0xfe0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3909dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 15) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3909dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3404dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3404dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3910dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3910dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
  tie_t = (val << 21) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3385dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3385dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 18) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3478dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3478dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 21) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3908dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3908dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3477dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3477dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 20) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3469dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 8) >> 23);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3469dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3484dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3484dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld3916dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3916dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_dsp340050b49a6c_fld3451dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3451dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 21) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3914dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3914dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3450dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3450dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 19) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3453dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 8) >> 18);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3453dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0xfffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3365dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3365dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3366dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3366dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3368dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3368dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3372dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3372dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3367dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3367dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3369dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3369dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3345dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 12) | ((insn[0] << 18) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3345dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x3ffc) | (tie_t << 2);
  tie_t = (val << 14) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3457dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 8) >> 25);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3457dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 21) >> 25;
  insn[0] = (insn[0] & ~0xfe0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3917dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 15) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3917dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3358dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 6) | ((insn[0] << 22) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3358dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f0) | (tie_t << 4);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 19) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3918dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3918dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3347dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 12) | ((insn[0] << 18) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3347dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x3ffc) | (tie_t << 2);
  tie_t = (val << 14) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3348dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 12) | ((insn[0] << 18) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3348dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x3ffc) | (tie_t << 2);
  tie_t = (val << 14) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3354dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 10) | ((insn[0] << 18) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3354dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff0) | (tie_t << 4);
  tie_t = (val << 16) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_s4_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3397dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3397dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3919dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3919dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3462dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3462dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3394dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3394dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3920dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 16) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3920dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3363dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3363dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3481dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3481dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3339dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3339dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3384dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3384dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 18) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3360dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3360dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3437dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3437dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3439dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3439dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3438dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3438dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3440dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3440dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3441dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3441dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3442dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3442dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3444dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3444dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3460dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3460dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3921dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3921dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3429dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3429dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3431dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3431dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3435dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3435dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3430dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3430dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3432dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3432dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3433dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3433dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3434dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3434dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3436dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3436dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3361dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3361dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3403dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3403dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
  tie_t = (val << 25) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3922dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3922dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3386dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3386dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 18) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2056_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2056_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld3923dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 5) | ((insn[0] << 25) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3923dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c) | (tie_t << 2);
  tie_t = (val << 18) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3324dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3324dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3325dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3325dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3340dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3340dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3327dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3327dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3342dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 6) | ((insn[0] << 22) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3342dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f0) | (tie_t << 4);
  tie_t = (val << 24) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3356dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  tie_t = (tie_t << 6) | ((insn[0] << 22) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3356dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f0) | (tie_t << 4);
  tie_t = (val << 23) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
  tie_t = (val << 17) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3924dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3924dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3349dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 22) | ((insn[0] << 8) >> 10);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3349dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 10) >> 10;
  insn[0] = (insn[0] & ~0xfffffc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3350dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 8) >> 25);
  tie_t = (tie_t << 13) | ((insn[0] << 17) >> 19);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3350dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x7ffc) | (tie_t << 2);
  tie_t = (val << 12) >> 25;
  insn[0] = (insn[0] & ~0xfe0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3341dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3341dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3370dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3370dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3371dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3371dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3373dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3373dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3374dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3374dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3376dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3376dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3375dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3375dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3377dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3377dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3378dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3378dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3379dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3379dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 14) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3381dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3381dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3448dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3448dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 19) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3925dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3925dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3454dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3454dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
  tie_t = (val << 19) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3466_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3466_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3412dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3412dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3927dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3927dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3382dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 7) | ((insn[0] << 22) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3382dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f8) | (tie_t << 3);
  tie_t = (val << 19) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3928dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3928dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3410_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3410_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3929dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 6) | ((insn[0] << 24) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3929dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc) | (tie_t << 2);
  tie_t = (val << 17) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3390dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 8) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3390dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0xfff000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3413dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3413dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3930dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 13) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3930dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x7fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3456dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3456dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
  tie_t = (val << 19) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3392dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 8) >> 21);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3392dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 17) >> 21;
  insn[0] = (insn[0] & ~0xffe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3900_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3900_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3337dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3337dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3446dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3446dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 20) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3317dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3317dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3458dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3458dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3319dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3319dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3320dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3320dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3322dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3322dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3399dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3399dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld3931dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 11) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3931dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x1c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3326dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3326dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3427dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3427dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3470dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3470dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3411dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 9) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3411dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x400000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3933dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3933dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
  tie_t = (val << 23) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_dsp340050b49a6c_fld3321dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3321dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3428dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3428dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_s_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_r_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_r_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3471dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3471dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3472dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3472dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3474dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3474dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3323dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3323dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3480dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3480dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3473dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3473dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3328dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3328dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3330dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3330dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3329dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3329dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3331dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3331dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3362dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3362dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3332dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3332dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3445dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3445dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3333dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3333dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3335dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3335dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3401dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3401dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
  tie_t = (val << 25) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3934dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3934dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3406dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3406dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_dsp340050b49a6c_fld3935dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 9) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3935dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x7c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3380dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3380dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 18) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3336dual_slot2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3336dual_slot2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_op0_s22_Slot_dual_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_op0_s22_Slot_dual_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_imm8_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_op0_s23_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 9) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_op0_s23_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x400000) | (tie_t << 22);
}

static unsigned
Field_dsp340050b49a6c_fld3532dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 10) >> 26);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3532dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 24) >> 26;
  insn[0] = (insn[0] & ~0x3f0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3602_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3602_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3533dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 10) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3533dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 25) >> 27;
  insn[0] = (insn[0] & ~0x3e0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3936dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 15) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3936dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2057_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2057_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3625dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 10) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3625dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 25) >> 26;
  insn[0] = (insn[0] & ~0x3f0000) | (tie_t << 16);
}

static unsigned
Field_r_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_r_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_t_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_t_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3487dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3487dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld3584_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3584_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3937dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3937dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3489dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3489dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3488dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 10) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3488dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380000) | (tie_t << 19);
}

static unsigned
Field_dsp340050b49a6c_fld3620dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3620dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2048_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2048_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3588dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 10) >> 27);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3588dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x3e0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3938dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 15) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3938dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x1c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3544dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3544dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3519dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3519dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 18) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3939dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3939dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3523dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 10) >> 21);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3523dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x3ff800) | (tie_t << 11);
}

static unsigned
Field_bbi_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 21) >> 27);
  return tie_t;
}

static void
Field_bbi_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3520dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3520dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 19) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2056_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2056_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld3507dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 10) >> 16);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3507dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0x3fffc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld3506dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 10) >> 17);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3506dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x3fff80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld3614dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3614dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2079_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2079_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3550dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3550dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3549dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3549dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3531_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 10) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3531_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3500dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3500dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 18) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3502dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3502dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 17) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3606dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3606dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3607dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3607dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3608dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3608dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_sae_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  return tie_t;
}

static void
Field_sae_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3619_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 10) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3619_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld3940dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 11) >> 25);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3940dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3613dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 10) >> 27);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3613dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 23) >> 27;
  insn[0] = (insn[0] & ~0x3e0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3509dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3509dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3510dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3510dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3562dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3562dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3560dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3560dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3499dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3499dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 19) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3563dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3563dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3565dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3565dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3564dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3564dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3566dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3566dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3512dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3512dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3567dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3567dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3504dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3504dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 17) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3516dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3516dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3568dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3568dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3570dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3570dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3580dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3580dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3559dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 5) | ((insn[0] << 25) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3559dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c) | (tie_t << 2);
  tie_t = (val << 19) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3573dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3573dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3599dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 10) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3599dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x3f0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3941dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3941dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3575dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3575dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3535dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3535dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2066_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2066_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3494dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3494dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3497dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3497dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3496dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3496dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3498dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3498dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
  tie_t = (val << 23) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3490dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3490dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3491dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3491dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3493dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3493dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3527dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3527dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3492dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3492dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3589dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3589dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_s8_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3541dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3541dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2037_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2037_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld3542dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3542dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3543dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3543dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3552_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3552_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3626dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 10) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3626dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 25) >> 26;
  insn[0] = (insn[0] & ~0x3f0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3621dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 10) >> 25);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3621dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 24) >> 25;
  insn[0] = (insn[0] & ~0x3f8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3623dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 10) >> 25);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3623dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 24) >> 25;
  insn[0] = (insn[0] & ~0x3f8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3622dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 10) >> 25);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3622dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 24) >> 25;
  insn[0] = (insn[0] & ~0x3f8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3624dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 10) >> 25);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3624dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 24) >> 25;
  insn[0] = (insn[0] & ~0x3f8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3529dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 10) >> 22);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3529dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld3530dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 10) >> 25);
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3530dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
  tie_t = (val << 23) >> 25;
  insn[0] = (insn[0] & ~0x3f8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2072_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2072_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3524dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 10) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 17) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3524dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x7800) | (tie_t << 11);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x3f0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3943dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 6) | ((insn[0] << 21) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3943dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x7e0) | (tie_t << 5);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3508dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3508dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3601dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3601dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3945dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3945dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3603dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3603dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3604dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3604dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3946dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3946dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3545dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3545dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3616dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3616dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld3947dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3947dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 25) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3618dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 10) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3618dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld3949dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 11) >> 25);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3949dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 24) >> 25;
  insn[0] = (insn[0] & ~0x1fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3609dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3609dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
  tie_t = (val << 19) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3546dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3546dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3548dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3548dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3554dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3554dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3547dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3547dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3522dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3522dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 19) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3950dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3950dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld3611dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3611dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
  tie_t = (val << 19) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3592dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3592dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3594dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3594dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3598dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 10) >> 26);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3598dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x3f0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3951dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3951dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3600dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 10) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3600dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0x3e0000) | (tie_t << 17);
}

static unsigned
Field_dsp340050b49a6c_fld3952dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3952dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3593dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3593dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3595dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3595dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3596dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3596dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3597dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3597dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3511dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3511dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3513dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3513dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3514dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3514dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3515dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3515dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3517dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3517dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3518dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3518dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 17) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld3536dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3536dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld2060_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2060_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3539dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3539dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3954dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3954dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3537dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3537dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3538dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3538dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_dsp340050b49a6c_fld3957dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3957dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld3587dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3587dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 21) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3610_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3610_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld3571dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3571dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3572dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3572dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3574dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3574dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3569dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 5) | ((insn[0] << 25) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3569dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c) | (tie_t << 2);
  tie_t = (val << 19) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3505dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 10) >> 18);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3505dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x3fff00) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld3612dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 10) >> 26);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3612dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 22) >> 26;
  insn[0] = (insn[0] & ~0x3f0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld3576dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3576dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 15) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3577dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3577dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 15) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3615dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 10) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3615dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x380000) | (tie_t << 19);
}

static unsigned
Field_dsp340050b49a6c_fld3958dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3958dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3551dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3551dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3553dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3553dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3590dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3590dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3591dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3591dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
  tie_t = (val << 20) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3555dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3555dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3557dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3557dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3578dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3578dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 15) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3579dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3579dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 15) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3581dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3581dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
  tie_t = (val << 16) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3582dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3582dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 17) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3959dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3959dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3556dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3556dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3558dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3558dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 19) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3583dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3583dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 18) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3960dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3960dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld3585dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3585dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
  tie_t = (val << 19) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld3961dual_slot0_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld3961dual_slot0_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_t_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_t_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_t_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_t_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_t_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_t_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_t_Slot_acc2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_t_Slot_acc2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_t_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_t_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_t_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_t_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_bbi_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_bbi_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_bbi_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 21) >> 27);
  return tie_t;
}

static void
Field_bbi_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c0) | (tie_t << 6);
}

static unsigned
Field_imm12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 8) >> 20);
  return tie_t;
}

static void
Field_imm12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff000) | (tie_t << 12);
}

static unsigned
Field_imm12_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 14) >> 20);
  return tie_t;
}

static void
Field_imm12_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x3ffc0) | (tie_t << 6);
}

static unsigned
Field_imm12_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 14) >> 20);
  return tie_t;
}

static void
Field_imm12_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x3ffc0) | (tie_t << 6);
}

static unsigned
Field_imm8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_imm8_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_s_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_s_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_s_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_s_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_s_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_s_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_s_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_s_Slot_acc2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_acc2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_s_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_s_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_s_Slot_smod_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_smod_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_s_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_s_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_s_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_s_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_imm12b_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_imm12b_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 14) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x3fc00) | (tie_t << 10);
}

static unsigned
Field_imm12b_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 14) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0x3fc00) | (tie_t << 10);
}

static unsigned
Field_imm16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 8) >> 16);
  return tie_t;
}

static void
Field_imm16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff00) | (tie_t << 8);
}

static unsigned
Field_imm16_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_imm16_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_offset_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_op2_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_op2_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_op2_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_op2_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_op2_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_op2_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_op2_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_r_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_r_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_r_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_r_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_r_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_r_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_r_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_r_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_r_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_r_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_r_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_r_Slot_acc2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_r_Slot_acc2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_r_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_r_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_r_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_r_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_r_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_r_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_sae_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_sae_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  return tie_t;
}

static void
Field_sae_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_sal_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sal_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sal_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sal_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sal_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sal_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sal_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sal_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sargt_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sargt_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sargt_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sargt_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sargt_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sargt_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sargt_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sargt_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sas4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_sas4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 25) >> 27);
  return tie_t;
}

static void
Field_sas_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c) | (tie_t << 2);
}

static unsigned
Field_sas_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 25) >> 27);
  return tie_t;
}

static void
Field_sas_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c) | (tie_t << 2);
}

static unsigned
Field_sas_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 25) >> 27);
  return tie_t;
}

static void
Field_sas_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c) | (tie_t << 2);
}

static unsigned
Field_sas_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 25) >> 27);
  return tie_t;
}

static void
Field_sas_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c) | (tie_t << 2);
}

static unsigned
Field_sr_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sr_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_sr_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sr_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_st_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_st_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_st_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_st_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_imm4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm4_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm4_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm4_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm4_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_mn_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_mn_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_i_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_i_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_imm6lo_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6lo_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm6lo_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6lo_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm6hi_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_imm6hi_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm6hi_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_imm6hi_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm7lo_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7lo_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm7lo_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7lo_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm7hi_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_imm7hi_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_imm7hi_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_imm7hi_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_z_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_z_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_imm6_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm6_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm6_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 20) >> 26);
  return tie_t;
}

static void
Field_imm6_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc0) | (tie_t << 6);
}

static unsigned
Field_imm6_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 20) >> 26);
  return tie_t;
}

static void
Field_imm6_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc0) | (tie_t << 6);
}

static unsigned
Field_imm6_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 20) >> 26);
  return tie_t;
}

static void
Field_imm6_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc0) | (tie_t << 6);
}

static unsigned
Field_imm6_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 20) >> 26);
  return tie_t;
}

static void
Field_imm6_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc0) | (tie_t << 6);
}

static unsigned
Field_imm7_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_imm7_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_imm7_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_imm7_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_imm7_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_imm7_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_imm7_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_imm7_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_imm7_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_imm7_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_imm7_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_imm7_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_imm7_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_imm7_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_imm7_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_imm7_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_imm7_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_imm7_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_imm7_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_imm7_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_t2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_t2_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_t2_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_s2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_s2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_s2_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_s2_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_s2_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_s2_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_r2_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_r2_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_t4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_t4_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_t4_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_s4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_s4_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_s4_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_s4_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_s4_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_s4_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_s4_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_r4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_r4_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_r4_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_t8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_t8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_t8_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_t8_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_t8_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_t8_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_s8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_s8_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_s8_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_s8_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_r8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_r8_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r8_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_r8_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r8_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_xt_wbr15_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 8) >> 17);
  return tie_t;
}

static void
Field_xt_wbr15_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfffe00) | (tie_t << 9);
}

static unsigned
Field_xt_wbr18_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_xt_wbr18_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_fimm8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_fimm8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_fimm8_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 14) >> 24);
  return tie_t;
}

static void
Field_fimm8_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2029_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2029_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_dsp340050b49a6c_fld2029_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2029_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2029_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2029_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2029_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2029_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2029_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2029_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2029_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2029_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2029_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2029_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2029_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2029_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2029_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2029_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2029_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2029_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2030_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2030_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_dsp340050b49a6c_fld2030_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2030_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2030_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2030_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2030_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2030_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2030_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2030_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2030_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2030_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2030_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2030_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2030_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2030_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2030_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2030_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2030_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2030_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2032_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2032_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_dsp340050b49a6c_fld2032_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2032_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2032_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2032_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2032_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2032_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2032_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2032_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2032_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2032_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2032_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2032_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2032_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2032_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2032_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2032_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2032_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2032_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2035_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2035_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2035_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2035_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2035_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2035_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2035_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2035_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2036_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2036_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2036_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2036_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2036_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2036_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2037_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2037_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2037_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2037_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2037_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2037_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2037_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2037_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2038_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2038_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld2038_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2038_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2038_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2038_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2038_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2038_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2038_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2038_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2038_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2038_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2038_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2038_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_dsp340050b49a6c_fld2039_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2039_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_dsp340050b49a6c_fld2039_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 25) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2039_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2039_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 25) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2039_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2039_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 25) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2039_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2039_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 25) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2039_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2040_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2040_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2040_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2040_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2040_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2040_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2040_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2040_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2040_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2040_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2041_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2041_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_dsp340050b49a6c_fld2041_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2041_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2041_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2041_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2041_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2041_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2041_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2041_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_dsp340050b49a6c_fld2042_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2042_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2042_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2042_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2042_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2042_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2042_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2042_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2043_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2043_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_dsp340050b49a6c_fld2043_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2043_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2043_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2043_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2043_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2043_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2043_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2043_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2043_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2043_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2043_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2043_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2044_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2044_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_dsp340050b49a6c_fld2044_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2044_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2044_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 25) >> 27);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2044_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2044_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2044_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2044_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2044_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2045_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2045_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_acc2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_smod_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_smod_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2046_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2046_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_acc2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_acc2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_smod_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_smod_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_llr_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_llr_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_dual_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_dual_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2047_Slot_dual_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2047_Slot_dual_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2048_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2048_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2048_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2048_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2048_Slot_dot_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2048_Slot_dot_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2048_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2048_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2048_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2048_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2048_Slot_acc2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2048_Slot_acc2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dsp340050b49a6c_fld2048_Slot_smod_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 26) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2048_Slot_smod_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2048_Slot_smod_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2048_Slot_smod_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2048_Slot_llr_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2048_Slot_llr_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 19) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x1800) | (tie_t << 11);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_gp_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_gp_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_dot_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_dot_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_pq_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_pq_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_pq_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_pq_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2049_Slot_llr_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2049_Slot_llr_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2050_Slot_gp_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2050_Slot_gp_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2050_Slot_gp_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2050_Slot_gp_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_dsp340050b49a6c_fld2050_Slot_dot_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2050_Slot_dot_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_dsp340050b49a6c_fld2050_Slot_dot_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2050_Slot_dot_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_dsp340050b49a6c_fld2050_Slot_pq_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 25) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2050_Slot_pq_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2050_Slot_pq_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2050_Slot_pq_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_dsp340050b49a6c_fld2050_Slot_acc2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 25) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2050_Slot_acc2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78) | (tie_t << 3);
}

static unsigned
Field_dsp340050b49a6c_fld2050_Slot_acc2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 25) >> 28);
  return tie_t;
}

static void
Field_dsp340050b49a6c_fld2050_Slot_acc2_slot0_set 