
Rule ID | Title | Category | Enabled | Severity | CodeFix | Description |
--------|-------|----------|---------|----------|---------|--------------------------------------------------------------------------------------------------------------|
RS1001 | Missing diagnostic analyzer attribute. | MicrosoftCodeAnalysisCorrectness | True | Warning | True | Non-abstract sub-types of DiagnosticAnalyzer should be marked with DiagnosticAnalyzerAttribute(s). The argument to this attribute(s), if any, determine the supported languages for the analyzer. Analyzer types without this attribute will be ignored by the analysis engine. |
RS1002 | Missing kind argument when registering an analyzer action. | MicrosoftCodeAnalysisCorrectness | True | Warning | False | You must specify at least one syntax, symbol or operation kind when registering a syntax, symbol, or operation analyzer action respectively. Otherwise, the registered action will never be invoked during analysis. |
RS1003 | Unsupported SymbolKind argument when registering a symbol analyzer action. | MicrosoftCodeAnalysisCorrectness | True | Warning | False | SymbolKind '{0}' is not supported for symbol analyzer actions. |
RS1004 | Recommend adding language support to diagnostic analyzer. | MicrosoftCodeAnalysisCorrectness | True | Warning | False | Diagnostic analyzer is marked as supporting only one language, but the analyzer assembly doesn't seem to refer to any language specific CodeAnalysis assemblies, and so is likely to work for more than one language. Consider adding an additional language argument to DiagnosticAnalyzerAttribute. |
RS1005 | ReportDiagnostic invoked with an unsupported DiagnosticDescriptor. | MicrosoftCodeAnalysisCorrectness | True | Warning | False | ReportDiagnostic should only be invoked with supported DiagnosticDescriptors that are returned from DiagnosticAnalyzer.SupportedDiagnostics property. Otherwise, the reported diagnostic will be filtered out by the analysis engine. |
RS1006 | Invalid type argument for DiagnosticAnalyzer's Register method. | MicrosoftCodeAnalysisCorrectness | True | Warning | False | DiagnosticAnalyzer's language-specific Register methods, such as RegisterSyntaxNodeAction, RegisterCodeBlockStartAction and RegisterCodeBlockEndAction, expect a language-specific 'SyntaxKind' type argument for it's 'TLanguageKindEnumName' type parameter. Otherwise, the registered analyzer action can never be invoked during analysis. |
RS1007 | Provide localizable arguments to diagnostic descriptor constructor. | MicrosoftCodeAnalysisLocalization | False | Warning | False | If your diagnostic analyzer and it's reported diagnostics need to be localizable, then the supported DiagnosticDescriptors used for constructing the diagnostics must also be localizable. If so, then localizable argument(s) must be provided for parameter 'title' (and optionally 'description') to the diagnostic descriptor constructor to ensure that the descriptor is localizable. |
RS1008 | Avoid storing per-compilation data into the fields of a diagnostic analyzer. | MicrosoftCodeAnalysisPerformance | True | Warning | False | Instance of a diagnostic analyzer might outlive the lifetime of compilation. Hence, storing per-compilation data, such as symbols, into the fields of a diagnostic analyzer might cause stale compilations to stay alive and cause memory leaks.  Instead, you should store this data on a separate type instantiated in a compilation start action, registered using 'AnalysisContext.RegisterCompilationStartAction' API. An instance of this type will be created per-compilation and it won't outlive compilation's lifetime, hence avoiding memory leaks. |
RS1009 | Only internal implementations of this interface are allowed. | MicrosoftCodeAnalysisCompatibility | True | Error | False | The author of this interface did not intend to have third party implementations of this interface and reserves the right to change it. Implementing this interface could therefore result in a source or binary compatibility issue with a future version of this interface. |
RS1010 | Create code actions should have a unique EquivalenceKey for FixAll occurrences support. | Correctness | True | Warning | False | A CodeFixProvider that intends to support fix all occurrences must classify the registered code actions into equivalence classes by assigning it an explicit, non-null equivalence key which is unique for each kind of code action created by this fixer. This enables the FixAllProvider to fix all diagnostics in the required scope by applying code actions from this fixer that are in the equivalence class of the trigger code action. |
RS1011 | Use code actions that have a unique EquivalenceKey for FixAll occurrences support. | Correctness | True | Warning | False | A CodeFixProvider that intends to support fix all occurrences must classify the registered code actions into equivalence classes by assigning it an explicit, non-null equivalence key which is unique for each kind of code action created by this fixer. This enables the FixAllProvider to fix all diagnostics in the required scope by applying code actions from this fixer that are in the equivalence class of the trigger code action. |
RS1012 | Start action has no registered actions. | MicrosoftCodeAnalysisPerformance | True | Warning | False | An analyzer start action enables performing stateful analysis over a given code unit, such as a code block, compilation, etc. Careful design is necessary to achieve efficient analyzer execution without memory leaks. Use the following guidelines for writing such analyzers:<br>1. Define a new scope for the registered start action, possibly with a private nested type for analyzing each code unit.<br>2. If required, define and initialize state in the start action.<br>3. Register at least one non-end action that refers to this state in the start action. If no such action is necessary, consider replacing the start action with a non-start action. For example, a CodeBlockStartAction with no registered actions or only a registered CodeBlockEndAction should be replaced with a CodeBlockAction.<br>4. If required, register an end action to report diagnostics based on the final state.<br> |
RS1013 | Start action has no registered non-end actions. | MicrosoftCodeAnalysisPerformance | True | Warning | False | An analyzer start action enables performing stateful analysis over a given code unit, such as a code block, compilation, etc. Careful design is necessary to achieve efficient analyzer execution without memory leaks. Use the following guidelines for writing such analyzers:<br>1. Define a new scope for the registered start action, possibly with a private nested type for analyzing each code unit.<br>2. If required, define and initialize state in the start action.<br>3. Register at least one non-end action that refers to this state in the start action. If no such action is necessary, consider replacing the start action with a non-start action. For example, a CodeBlockStartAction with no registered actions or only a registered CodeBlockEndAction should be replaced with a CodeBlockAction.<br>4. If required, register an end action to report diagnostics based on the final state.<br> |
RS1014 | Do not ignore values returned by methods on immutable objects. | MicrosoftCodeAnalysisCorrectness | True | Warning | False | Many objects exposed by Roslyn are immutable. The return value from a method invocation on these objects should not be ignored. |
RS1015 | Provide non-null 'helpLinkUri' value to diagnostic descriptor constructor. | MicrosoftCodeAnalysisDocumentation | False | Warning | False | The 'helpLinkUri' value is used to show information when this diagnostic in the error list. Every analyzer should have a helpLinkUri specified which points to a help page that does not change over time. |
RS1016 | Code fix providers should provide FixAll support. | Correctness | True | Warning | True | A CodeFixProvider should provide FixAll support to enable users to fix multiple instances of the underlying diagnostic with a single code fix. See documenation at https://github.com/dotnet/roslyn/blob/master/docs/analyzers/FixAllProvider.md for further details. |
RS1017 | DiagnosticId for analyzers must be a non-null constant. | MicrosoftCodeAnalysisDesign | True | Warning | False | DiagnosticId for analyzers must be a non-null constant. |
RS1018 | DiagnosticId for analyzers must be in specified format. | MicrosoftCodeAnalysisDesign | True | Warning | False | DiagnosticId for analyzers must be in specified format. |
RS1019 | DiagnosticId must be unique across analyzers. | MicrosoftCodeAnalysisDesign | True | Warning | False | DiagnosticId must be unique across analyzers. |
RS1020 | Category for analyzers must be from the specified values. | MicrosoftCodeAnalysisDesign | False | Warning | False | Category for analyzers must be from the specified values. |
RS1021 | Invalid entry in analyzer category and diagnostic ID range specification file. | MicrosoftCodeAnalysisDesign | True | Warning | False | Invalid entry in analyzer category and diagnostic ID range specification file. |
RS1022 | Do not use types from Workspaces assembly in an analyzer | MicrosoftCodeAnalysisCorrectness | True | Warning | False | Diagnostic analyzer types should not use types from Workspaces assemblies. Workspaces assemblies are only available when the analyzer executes in Visual Studio IDE live analysis, but are not available during command line build. Referencing types from Workspaces assemblies will lead to runtime exception during analyzer execution in command line build. |
[RS1023](https://go.microsoft.com/fwlink/?linkid=874285) | Upgrade MSBuildWorkspace | Library | True | Warning | False | MSBuildWorkspace has moved to the Microsoft.CodeAnalysis.Workspaces.MSBuild NuGet package and there are breaking API changes. |
RS1024 | Compare symbols correctly | MicrosoftCodeAnalysisCorrectness | True | Warning | True | Symbols should be compared for equality, not identity. |
RS1025 | Configure generated code analysis | MicrosoftCodeAnalysisCorrectness | True | Warning | True | Configure generated code analysis |
RS1026 | Enable concurrent execution | MicrosoftCodeAnalysisCorrectness | True | Warning | True | Enable concurrent execution |
RS1027 | Types marked with DiagnosticAnalyzerAttribute(s) should inherit from DiagnosticAnalyzer. | MicrosoftCodeAnalysisCorrectness | True | Warning | False | Inherit type '{0}' from DiagnosticAnalyzer or remove the DiagnosticAnalyzerAttribute(s). |
RS1028 | Provide non-null 'customTags' value to diagnostic descriptor constructor. | MicrosoftCodeAnalysisDocumentation | False | Warning | False | The 'customTags' value is used as a way to enable specific actions and filters on diagnostic descriptors based on the specific values of the tags. Every Roslyn analyzer should have at least one tag from the 'WellKnownDiagnosticTags' class. |
RS1029 | Do not use reserved diagnostic IDs. | MicrosoftCodeAnalysisDesign | True | Warning | False | DiagnosticId for analyzers should not use reserved IDs. |
RS1030 | Do not invoke Compilation.GetSemanticModel() method within a diagnostic analyzer | MicrosoftCodeAnalysisCorrectness | True | Warning | False | 'GetSemanticModel' is an expensive method to invoke within a diagnostic analyzer because it creates a completely new semantic model, which does not share compilation data with the compiler or other analyzers. This incurs an additional performance cost during semantic analysis. Instead, consider registering a different analyzer action which allows used of a shared 'SemanticModel', such as 'RegisterOperationAction', 'RegisterSyntaxNodeAction', or 'RegisterSemanticModelAction'. |
[RS2000](https://github.com/dotnet/roslyn-analyzers/blob/master/src/Microsoft.CodeAnalysis.Analyzers/ReleaseTrackingAnalyzers.Help.md) | Add analyzer diagnostic IDs to analyzer release. | MicrosoftCodeAnalysisReleaseTracking | True | Warning | True | All supported analyzer diagnostic IDs should be part of an analyzer release. |
[RS2001](https://github.com/dotnet/roslyn-analyzers/blob/master/src/Microsoft.CodeAnalysis.Analyzers/ReleaseTrackingAnalyzers.Help.md) | Ensure up-to-date entry for analyzer diagnostic IDs are added to analyzer release. | MicrosoftCodeAnalysisReleaseTracking | True | Warning | True | Ensure up-to-date entry for analyzer diagnostic IDs are added to analyzer release. |
[RS2002](https://github.com/dotnet/roslyn-analyzers/blob/master/src/Microsoft.CodeAnalysis.Analyzers/ReleaseTrackingAnalyzers.Help.md) | Do not add removed analyzer diagnostic IDs to unshipped analyzer release. | MicrosoftCodeAnalysisReleaseTracking | True | Warning | False | Entries for analyzer diagnostic IDs that are no longer reported and never shipped can be removed from unshipped analyzer release. |
[RS2003](https://github.com/dotnet/roslyn-analyzers/blob/master/src/Microsoft.CodeAnalysis.Analyzers/ReleaseTrackingAnalyzers.Help.md) | Shipped diagnostic IDs that are no longer reported should have an entry in the 'Removed Rules' table in unshipped file. | MicrosoftCodeAnalysisReleaseTracking | True | Warning | False | Shipped diagnostic IDs that are no longer reported should have an entry in the 'Removed Rules' table in unshipped file. |
[RS2004](https://github.com/dotnet/roslyn-analyzers/blob/master/src/Microsoft.CodeAnalysis.Analyzers/ReleaseTrackingAnalyzers.Help.md) | Diagnostic IDs marked as removed in analyzer release file should not be reported by analyzers. | MicrosoftCodeAnalysisReleaseTracking | True | Warning | False | Diagnostic IDs marked as removed in analyzer release file should not be reported by analyzers. |
[RS2005](https://github.com/dotnet/roslyn-analyzers/blob/master/src/Microsoft.CodeAnalysis.Analyzers/ReleaseTrackingAnalyzers.Help.md) | Remove duplicate entries for diagnostic ID in the same analyzer release. | MicrosoftCodeAnalysisReleaseTracking | True | Warning | False | Remove duplicate entries for diagnostic ID in the same analyzer release. |
[RS2006](https://github.com/dotnet/roslyn-analyzers/blob/master/src/Microsoft.CodeAnalysis.Analyzers/ReleaseTrackingAnalyzers.Help.md) | Remove duplicate entries for diagnostic ID between analyzer releases. | MicrosoftCodeAnalysisReleaseTracking | True | Warning | False | Remove duplicate entries for diagnostic ID between analyzer releases. |
[RS2007](https://github.com/dotnet/roslyn-analyzers/blob/master/src/Microsoft.CodeAnalysis.Analyzers/ReleaseTrackingAnalyzers.Help.md) | Invalid entry in analyzer release file. | MicrosoftCodeAnalysisReleaseTracking | True | Warning | False | Invalid entry in analyzer release file. |
[RS2008](https://github.com/dotnet/roslyn-analyzers/blob/master/src/Microsoft.CodeAnalysis.Analyzers/ReleaseTrackingAnalyzers.Help.md) | Enable analyzer release tracking | MicrosoftCodeAnalysisReleaseTracking | True | Warning | True | Enabling release tracking for analyzer packages helps in tracking and documenting the analyzer diagnostics that ship and/or change with each analyzer release. See details at https://github.com/dotnet/roslyn-analyzers/blob/master/src/Microsoft.CodeAnalysis.Analyzers/ReleaseTrackingAnalyzers.Help.md. |
